/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: PropertyBeanBeanInfo.java 62554 2011-04-15 18:08:28Z dougd $
 */

package com.sun.ts.tests.jsp.spec.core_syntax.actions.setproperty;

import java.beans.PropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.SimpleBeanInfo;
import java.util.Arrays;

public class PropertyBeanBeanInfo extends SimpleBeanInfo 
{
    private PropertyDescriptor[] pd = null;

    public PropertyBeanBeanInfo () {
        
    }

    /**
     *
     * @return an array of PropertyDescriptors describing the PropertyBean's 
     *         exposed properties.
     */
    public PropertyDescriptor[] getPropertyDescriptors() {
        if ( pd == null ) {
            try {
                pd = new PropertyDescriptor[] {
                    new PropertyDescriptor( "PString" ,PropertyBean.class ),
                    new PropertyDescriptor( "PBoolean", PropertyBean.class ),
                    new PropertyDescriptor( "PInteger", PropertyBean.class )
                };

                pd[ 0 ].setPropertyEditorClass( PStringPropertyEditor.class );
                pd[ 1 ].setPropertyEditorClass( PBooleanPropertyEditor.class );
                pd[ 2 ].setPropertyEditorClass( PIntegerPropertyEditor.class );
            } catch ( IntrospectionException ie ) {
                pd = super.getPropertyDescriptors();
            }
        }
        return Arrays.copyOf(pd, pd.length);
    }

    
}// PropertyBeanBeanInfo
