/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: CheckOperatorTag.java 62554 2011-04-15 18:08:28Z dougd $
 */

 
package com.sun.ts.tests.jsp.spec.core_syntax.scripting.el;

import javax.servlet.jsp.JspException;

/**
 * Tag implementation to validate the various operators
 * provided by the JSP 2.0 expression language.
 */
public class CheckOperatorTag extends BaseCheckTag {

    /**
     * Validate the control and test objects
     * using the following algorithm:
     * <ul>
     *  <li>If either the control or test objects
     *      are null, FAIL.</li>
     *  <li>If both objects, converted to a String,
     *      are not equal, FAIL.</li>
     * </ul>
     * @throws JspException if an error occurs
     */
    protected void performCheck() throws JspException {
        String message = null;

        if (_control == null || _object == null) {
            message = "Test FAILED (" + _name + ").  Either the control or" +
                " the object under test was null.";
        } else {
            if (!_control.toString().equals(_object.toString())) {
                message = "Test FAILED (" + _name + ").  " +
                    " Expected: " + _control + ", Received: " + _object;
            }
        }
        displayTestStatus(message);
    }
}
