<%--
   Copyright 2003 - 2009 Sun Microsystems, Inc.  All rights reserved.
   SUN PROPRIETARY/CONFIDENTIAL.  Use is subject license terms.
--%>

<%@ page import="com.sun.ts.tests.jsp.common.util.JspTestUtil,
                 java.io.IOException,
                 javax.servlet.jsp.el.VariableResolver,
                 javax.servlet.jsp.el.ELException" %>
<%@ page contentType="text/plain" %>

<%!
    private static final String PAGECONTEXT_ATTR =
        "com.sun.ts.tests.jsp.api.pageContext";
%>

<%-- Begin test definitions --%>

<%!
    public void variableResolverResolveVariableTest(HttpServletRequest req,
                                                    HttpServletResponse res,
                                                    JspWriter out)
    throws ServletException, IOException {
        PageContext pc = (PageContext) req.getAttribute(PAGECONTEXT_ATTR);
        if (pc != null) {
            pc.setAttribute("myObj", "value");
            pc.setAttribute("myObj1", "value", PageContext.REQUEST_SCOPE);
            VariableResolver resolver = pc.getVariableResolver();
            if (resolver != null) {
                try {
                    String res1 = (String)
                        resolver.resolveVariable("myObj");
                    if (res1.equals("value")) {
                        try {
                            String res2 = (String)
                                resolver.resolveVariable("myObj1");
                            if (res2.equals("value")) {
                                try {
                                    Object res3 = resolver.resolveVariable(
                                        "com.sun.ts.tests.jsp.api.nonAttr");
                                    if (res3 == null) {
                                        out.println("Test PASSED");
                                    } else {
                                        out.println("Test FAILED.  Expected null, but " +
                                            "VariableResolver returned a non-null value.");
                                    }
                                } catch (ELException elenn) {
                                    out.println("Test FAILED.  Unexpected Exception.");
                                }

                            } else {
                                out.println("Test FAILED.  Resolution failed.");
                                out.println("Expected a value of 'value'");
                                out.println("Received: " + res2);
                            }
                        } catch (ELException elen) {
                            out.println("Test FAILED.  Unable to resolve 'myObj1'");
                            return;
                        }
                    } else {
                        out.println("Test FAILED.  Resolution failed.");
                        out.println("Expected a value of 'value'");
                        out.println("Received: " + res1);
                    }
                } catch (ELException ele) {
                    out.println("Test FAILED.  Unable to resolve 'myObj'");
                    return;
                }
            } else {
                out.println("Test FAILED.  VariableResolver was null");
            }
        } else {
            out.println("Test FAILED.  Unable to obtain PageContext.");
        }
    }
%>


<%-- Test invocation --%>

<%
    request.setAttribute(PAGECONTEXT_ATTR, pageContext);
    JspTestUtil.invokeTest(this, request, response, out);
%>
