<%--
   Copyright 2003 - 2009 Sun Microsystems, Inc.  All rights reserved.
   SUN PROPRIETARY/CONFIDENTIAL.  Use is subject license terms.
--%>

<%@ page import="com.sun.ts.tests.jsp.common.util.JspTestUtil,
                 java.io.IOException,
                 com.sun.ts.tests.jsp.common.util.SimpleContext" %>
<%@ page contentType="text/plain" %>

<%-- Begin test definitions --%>

<%!
    public void jspFactoryGetDefaultFactoryTest(HttpServletRequest req,
                                                HttpServletResponse res,
                                                JspWriter out)
    throws ServletException, IOException {
        JspFactory factory = JspFactory.getDefaultFactory();
        if (factory != null) {
            out.println("Test PASSED");
        } else {
            out.println("Test FAILED.  JspFactory.getDefaultFactory() " +
                "returned null.");
        }
    }
%>

<%!
    public void jspFactoryGetPageContextTest(HttpServletRequest req,
                                             HttpServletResponse res,
                                             JspWriter out)
    throws ServletException, IOException {
        JspFactory factory = JspFactory.getDefaultFactory();
        if (factory != null) {
            PageContext pc = factory.getPageContext(this, req, res, "",
                true, 2048, true);
            if (pc != null) {
                out.println("Test PASSED");
            } else {
                out.println("Test FAILED.  JspFactory.getPageContext() returned" +
                    " null.");
            }
        } else {
            out.println("Test FAILED.  JspFactory.getDefaultFactory() " +
                "returned null.");
        }
    }
%>

<%!
    public void jspFactoryGetEngineInfoTest(HttpServletRequest req,
                                            HttpServletResponse res,
                                            JspWriter out)
    throws ServletException, IOException {
        JspFactory factory = JspFactory.getDefaultFactory();
        if (factory != null) {
            JspEngineInfo info = factory.getEngineInfo();
            if (info != null) {
                out.println("Test PASSED");
            } else {
                out.println("Test FAILED.  JspFactory.getEngineInfo() " +
                    "returned null.");
            }
        } else {
            out.println("Test FAILED.  JspFactory.getDefaultFactory() " +
                "returned null.");
        }
    }
%>

<%-- Test invocation --%>

<% JspTestUtil.invokeTest(this, request, response, out); %>
