<%--
   Copyright 2003 - 2009 Sun Microsystems, Inc.  All rights reserved.
   SUN PROPRIETARY/CONFIDENTIAL.  Use is subject license terms.
--%>

<%@ page import="com.sun.ts.tests.jsp.common.util.JspTestUtil,
                 java.io.Reader"%>
<%@ page contentType="text/plain" %>
<%@ taglib tagdir="/WEB-INF/tags" prefix="tags" %>

<tags:DoBodyScopeTag>
    Body Content
</tags:DoBodyScopeTag>

<%
    final int[] scopes = {
        PageContext.REQUEST_SCOPE,
        PageContext.SESSION_SCOPE,
        PageContext.APPLICATION_SCOPE
    };

    final String[] attrNames = {
        "requestVar", "sessionVar", "applicationVar"
    };

    for (int i = 0; i < scopes.length; i++) {
        Object o = pageContext.getAttribute(attrNames[i], scopes[i]);
        if (o != null) {
            if (o instanceof Reader) {
                Reader r = (Reader) o;
                StringBuffer sb = new StringBuffer();
                for (int read = r.read(); read != -1; read = r.read()) {
                    sb.append((char) read);
                }
                o = sb.toString();
            }

            if (((String) o).trim().equals("Body Content")) {
                out.println("Test PASSED");
            } else {
                out.println("Test FAILED.  Attribute found in the " +
                    JspTestUtil.getScopeName(scopes[i]) + ", but the value" +
                    " of the attribute was not 'Body Content'.  Received" +
                    ": " + o);
            }
        } else {
            out.println("Test FAILED.  Unable to find attribute '" +
                attrNames[i] + "' in the " + JspTestUtil.getScopeName(scopes[i]) +
                " scope.");
        }
    }

%>
