/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.lang.ref.WeakReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Function;

class JavaScriptBackgroundJob
implements Runnable {
    private final WeakReference<Window> window_;
    private final int timeout_;
    private final String script_;
    private final boolean loopForever_;
    private final Function function_;
    private final String label_;

    JavaScriptBackgroundJob(Window window, int timeout, String script, boolean loopForever, String label) {
        this.window_ = new WeakReference<Window>(window);
        this.timeout_ = timeout;
        this.loopForever_ = loopForever;
        this.script_ = script;
        this.function_ = null;
        this.label_ = label;
    }

    JavaScriptBackgroundJob(Window window, int timeout, Function function, boolean loopForever, String label) {
        this.window_ = new WeakReference<Window>(window);
        this.timeout_ = timeout;
        this.loopForever_ = loopForever;
        this.script_ = null;
        this.function_ = function;
        this.label_ = label;
    }

    public void run() {
        try {
            do {
                Thread.sleep(this.timeout_);
                Window w = (Window)this.window_.get();
                if (w == null) break;
                WebWindow ww = w.getWebWindow();
                Page page = ww.getEnclosedPage();
                if (this.getLog().isDebugEnabled()) {
                    String message = "Executing JavaScriptBackgroundJob (" + this.label_ + "):";
                    message = this.function_ == null ? message + this.script_ : message + "(function reference)";
                    this.getLog().debug((Object)message);
                }
                if (!ww.getWebClient().getWebWindows().contains(ww) || ww.getEnclosedPage() != page) {
                    this.getLog().debug((Object)"The page that originated this job doesn't exist anymore. Execution cancelled.");
                } else {
                    HtmlPage htmlPage = (HtmlPage)page;
                    if (this.function_ == null) {
                        htmlPage.executeJavaScriptIfPossible(this.script_, "JavaScriptBackgroundJob", 1);
                    } else {
                        HtmlElement doc = htmlPage.getDocumentElement();
                        htmlPage.executeJavaScriptFunctionIfPossible(this.function_, w, new Object[0], doc);
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                    this.getLog().debug((Object)("JavaScript " + this.label_ + " thread interrupted; clearTimeout() probably called."));
                }
                break;
            } while (this.loopForever_);
        }
        catch (InterruptedException e) {
            this.getLog().debug((Object)"JavaScript timeout thread interrupted; clearTimeout() probably called.");
        }
        catch (Exception e) {
            this.getLog().error((Object)"Caught exception in Window.setTimeout().", (Throwable)e);
        }
    }

    private Log getLog() {
        return LogFactory.getLog(this.getClass());
    }
}

