/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.xml.XmlElement;
import org.apache.commons.collections.map.ListOrderedMap;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class NamedNodeMap
extends SimpleScriptable
implements ScriptableWithFallbackGetter,
org.w3c.dom.NamedNodeMap {
    private static final long serialVersionUID = -1910087049570242560L;
    private final ListOrderedMap nodes_ = new ListOrderedMap();
    private final boolean caseInsensitive_;
    public static final org.w3c.dom.NamedNodeMap EMPTY_NODE_MAP = new NamedNodeMap();

    public NamedNodeMap() {
        this.caseInsensitive_ = true;
    }

    public NamedNodeMap(HtmlElement element) {
        this.caseInsensitive_ = true;
        for (DomAttr attr : element.getAttributesCollection()) {
            this.nodes_.put((Object)attr.getName().toLowerCase(), (Object)attr);
        }
        this.setParentScope((Scriptable)element.getScriptObject());
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    public NamedNodeMap(XmlElement element) {
        this.caseInsensitive_ = false;
        for (DomAttr attr : element.getAttributesMap().values()) {
            this.nodes_.put((Object)attr.getName(), (Object)attr);
        }
        this.setParentScope((Scriptable)element.getScriptObject());
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    public final Object get(int index, Scriptable start) {
        NamedNodeMap map = (NamedNodeMap)start;
        if (index >= 0 && index < map.nodes_.size()) {
            DomNode attr = (DomNode)map.nodes_.getValue(index);
            return attr.getScriptObject();
        }
        return NOT_FOUND;
    }

    public Object getWithFallback(String name) {
        DomNode attr;
        if (this.caseInsensitive_) {
            name = name.toLowerCase();
        }
        if ((attr = (DomNode)this.nodes_.get((Object)name)) != null) {
            return attr.getScriptObject();
        }
        return NOT_FOUND;
    }

    public Object jsxFunction_getNamedItem(String name) {
        DomNode attr;
        if (this.caseInsensitive_) {
            name = name.toLowerCase();
        }
        if ((attr = (DomNode)this.nodes_.get((Object)name)) != null) {
            return attr.getScriptObject();
        }
        return null;
    }

    public int jsxGet_length() {
        return this.nodes_.size();
    }

    public int getLength() {
        return this.jsxGet_length();
    }

    public Attr getNamedItem(String name) {
        if (this.caseInsensitive_) {
            name = name.toLowerCase();
        }
        return (Attr)this.nodes_.get((Object)name);
    }

    public Attr getNamedItemNS(String namespaceURI, String localName) {
        throw new UnsupportedOperationException("NamedNodeMap.getNamedItemNS is not yet implemented.");
    }

    public Attr item(int index) {
        return (Attr)this.nodes_.getValue(index);
    }

    public Node removeNamedItem(String name) throws DOMException {
        throw new UnsupportedOperationException("NamedNodeMap.removeNamedItem is not yet implemented.");
    }

    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        throw new UnsupportedOperationException("NamedNodeMap.removeNamedItemNS is not yet implemented.");
    }

    public Node setNamedItem(Node arg) throws DOMException {
        throw new UnsupportedOperationException("NamedNodeMap.setNamedItem is not yet implemented.");
    }

    public Node setNamedItemNS(Node arg) throws DOMException {
        throw new UnsupportedOperationException("NamedNodeMap.setNamedItemNS is not yet implemented.");
    }
}

