/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Attr;
import com.gargoylesoftware.htmlunit.javascript.host.BoxObject;
import com.gargoylesoftware.htmlunit.javascript.host.DOMImplementation;
import com.gargoylesoftware.htmlunit.javascript.host.DocumentFragment;
import com.gargoylesoftware.htmlunit.javascript.host.EventNode;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.Location;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.XPathNSResolver;
import com.gargoylesoftware.htmlunit.javascript.host.XPathResult;
import java.io.IOException;
import org.mozilla.javascript.Context;
import org.w3c.dom.Element;

public class Document
extends EventNode {
    private static final long serialVersionUID = 3700830050839613384L;
    private Window window_;
    private DOMImplementation implementation_;

    void setWindow(Window window) {
        this.window_ = window;
    }

    public Location jsxGet_location() {
        return this.window_.jsxGet_location();
    }

    public void jsxSet_location(String location) throws IOException {
        this.window_.jsxSet_location(location);
    }

    public String jsxGet_referrer() {
        String referrer = this.getPage().getWebResponse().getResponseHeaderValue("referrer");
        if (referrer == null) {
            return "";
        }
        return referrer;
    }

    public SimpleScriptable jsxGet_documentElement() {
        Element documentElement = this.getPage().getDocumentElement();
        if (documentElement == null) {
            return null;
        }
        return this.getScriptableFor(documentElement);
    }

    protected SgmlPage getPage() {
        return (SgmlPage)this.getDomNodeOrDie();
    }

    public Object jsxGet_defaultView() {
        return this.getWindow();
    }

    public Object jsxFunction_createDocumentFragment() {
        DomDocumentFragment fragment = ((SgmlPage)this.getDomNodeOrDie().getPage()).createDomDocumentFragment();
        DocumentFragment node = new DocumentFragment();
        node.setParentScope(this.getParentScope());
        node.setPrototype(this.getPrototype(((Object)((Object)node)).getClass()));
        node.setDomNode(fragment);
        return this.getScriptableFor(fragment);
    }

    public Attr jsxFunction_createAttribute(String attributeName) {
        Attr att = new Attr();
        att.setPrototype(this.getPrototype(Attr.class));
        att.setParentScope(this.getWindow());
        att.init(attributeName, null);
        return att;
    }

    public BoxObject jsxFunction_getBoxObjectFor(HTMLElement element) {
        return element.getBoxObject();
    }

    public Object jsxFunction_importNode(Node importedNode, boolean deep) {
        return importedNode.getDomNodeOrDie().cloneNode(deep).getScriptObject();
    }

    public DOMImplementation jsxGet_implementation() {
        if (this.implementation_ == null) {
            this.implementation_ = new DOMImplementation();
            this.implementation_.setParentScope(this.getWindow());
            this.implementation_.setPrototype(this.getPrototype(((Object)((Object)this.implementation_)).getClass()));
        }
        return this.implementation_;
    }

    public XPathNSResolver jsxFunction_createNSResolver(Node nodeResolver) {
        XPathNSResolver resolver = new XPathNSResolver();
        resolver.setElement(nodeResolver);
        resolver.setParentScope(this.getWindow());
        resolver.setPrototype(this.getPrototype(((Object)((Object)resolver)).getClass()));
        return resolver;
    }

    public Object jsxFunction_createTextNode(String newData) {
        Object result = NOT_FOUND;
        try {
            DomText domNode = new DomText(this.getDomNodeOrDie().getPage(), newData);
            SimpleScriptable jsElement = this.getScriptableFor(domNode);
            if (jsElement == NOT_FOUND) {
                this.getLog().debug((Object)("createTextNode(" + newData + ") cannot return a result as there isn't a JavaScript object for the DOM node " + domNode.getClass().getName()));
            } else {
                result = jsElement;
            }
        }
        catch (ElementNotFoundException elementNotFoundException) {
            // empty catch block
        }
        return result;
    }

    public XPathResult jsxFunction_evaluate(String expression, Node contextNode, Object resolver, int type, Object result) {
        XPathResult xPathResult = (XPathResult)((Object)result);
        if (xPathResult == null) {
            xPathResult = new XPathResult();
            xPathResult.setParentScope(this.getParentScope());
            xPathResult.setPrototype(this.getPrototype(((Object)((Object)xPathResult)).getClass()));
        }
        xPathResult.init(contextNode.getDomNodeOrDie().getByXPath(expression), type);
        return xPathResult;
    }

    public Object jsxFunction_createElement(String tagName) {
        Object result = NOT_FOUND;
        try {
            BrowserVersion browserVersion = this.getBrowserVersion();
            if (tagName.startsWith("<") && tagName.endsWith(">") && browserVersion.isNetscape() && !(tagName = tagName.substring(1, tagName.length() - 1)).matches("\\w+")) {
                this.getLog().error((Object)"Unexpected exception occurred while parsing HTML snippet");
                throw Context.reportRuntimeError((String)("Unexpected exception occurred while parsing HTML snippet: " + tagName));
            }
            SgmlPage page = this.getPage();
            Element element = page.createElement(tagName);
            SimpleScriptable jsElement = this.getScriptableFor(element);
            if (jsElement == NOT_FOUND) {
                this.getLog().debug((Object)("createElement(" + tagName + ") cannot return a result as there isn't a JavaScript object for the element " + element.getClass().getName()));
            } else {
                result = jsElement;
            }
        }
        catch (ElementNotFoundException elementNotFoundException) {
            // empty catch block
        }
        return result;
    }
}

