/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.securityapi.idstore.ldap.basic;

import javax.security.enterprise.identitystore.LdapIdentityStoreDefinition.LdapSearchScope;
import static javax.security.enterprise.identitystore.LdapIdentityStoreDefinition.LdapSearchScope.ONE_LEVEL;

import java.io.IOException;

import javax.annotation.security.DeclareRoles;
import javax.security.enterprise.identitystore.LdapIdentityStoreDefinition;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


/**
 * Test Servlet that prints out the name of the authenticated caller and whether
 * this caller is in any of the roles {Administrator, Manager, Employee}
 *
 */

@LdapIdentityStoreDefinition(
	    url = "ldap://localhost:11389/",
		//url = "${LDAP_URL}",
	    callerBaseDn = "ou=caller,dc=securityapi,dc=net",
	    callerSearchScope = LdapSearchScope.ONE_LEVEL,
	    groupSearchBase  = "ou=group,dc=securityapi,dc=net",		
		groupSearchFilter = "(&(member=%s)(objectClass=groupOfNames))",
	    groupSearchScope = LdapSearchScope.ONE_LEVEL
	)

@DeclareRoles({"Administrator", "Manager", "Employee"})
@WebServlet("/ServletForLdapIDStore")
public class ServletForLdapIDStore extends HttpServlet {   
   

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

    	 System.out.println("Inside ServletForIDStoreLdapOnly:doGet() ....." + "<BR>");
     	
         String webName = null;
         if (request.getUserPrincipal() != null) {
         	System.out.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");             
             webName = request.getUserPrincipal().getName();
         }

         response.getWriter().write("web username: " + webName + "\n");  
    }

}
