/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
*/
package com.sun.ts.tests.securityapi.securitycontext.ejb;

import java.security.Principal;
import java.util.Set;

import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.PermitAll;
import javax.ejb.EJBContext;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.security.enterprise.AuthenticationStatus;
import javax.security.enterprise.SecurityContext;
import javax.security.enterprise.authentication.mechanism.http.AuthenticationParameters;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Stateless
@DeclareRoles({"Administrator", "Manager", "Employee"})
@PermitAll
public class TestEJB {
    
    @Inject
    private SecurityContext securityContext;
    
    public Principal getCallerPrincipal() {
        return securityContext.getCallerPrincipal();
    }

    public boolean isCallerInRole(String role) {
        return securityContext.isCallerInRole(role);
    }
    
    public AuthenticationStatus authenticate(HttpServletRequest request, HttpServletResponse response, AuthenticationParameters parameters) {
        return securityContext.authenticate(request, response, parameters);
    }
}
