/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Vector;

public abstract class BackupPolicy {
    public void backup(File file) throws IOException, SecurityException {
        File backup;
        boolean ok;
        if (!this.isBackupRequired(file)) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            throw new IOException("Cannot backup a directory");
        }
        if (!file.canWrite()) {
            throw new IOException("File is write-protected");
        }
        File canon = new File(file.getCanonicalPath());
        String p = canon.getParent();
        if (p == null) {
            throw new IOException("Cannot determine parent directory of " + file);
        }
        File dir = new File(p);
        String[] dirFiles = dir.list();
        String prefix = file.getName() + "~";
        String suffix = "~";
        int maxBackupIndex = 0;
        Vector<Integer> backups = new Vector<Integer>();
        if (dirFiles != null) {
            block0: for (int i = 0; i < dirFiles.length; ++i) {
                String s = dirFiles[i];
                if (s.length() <= prefix.length() + suffix.length() || !s.startsWith(prefix) || !s.endsWith(suffix)) continue;
                String mid = s.substring(prefix.length(), s.length() - suffix.length());
                for (int m = 0; m < mid.length(); ++m) {
                    if (!Character.isDigit(mid.charAt(m))) break block0;
                }
                int index = Integer.parseInt(mid);
                if (index > maxBackupIndex) {
                    maxBackupIndex = index;
                }
                backups.addElement(new Integer(index));
            }
        }
        if (!(ok = file.renameTo(backup = new File(file.getPath() + "~" + ++maxBackupIndex + "~")))) {
            throw new IOException("failed to backup file: " + file);
        }
        int numBackupsToKeep = this.getNumBackupsToKeep(file);
        for (int i = 0; i < backups.size(); ++i) {
            int index = (Integer)backups.elementAt(i);
            if (index > maxBackupIndex - numBackupsToKeep) continue;
            File backupToGo = new File(file.getPath() + "~" + index + "~");
            boolean ignore = backupToGo.delete();
        }
    }

    public void backupAndRename(File source, File target) throws IOException, SecurityException {
        if (!source.exists()) {
            return;
        }
        if (source.isDirectory()) {
            throw new IOException("Cannot backup a directory.");
        }
        if (!source.canWrite()) {
            throw new IOException("Cannot rename, source file is write-protected " + source.getPath());
        }
        if (this.isBackupRequired(target)) {
            this.backup(target);
        } else if (target.exists()) {
            target.delete();
        }
        boolean result = source.renameTo(target);
        if (!result) {
            throw new IOException("Rename of " + target.getPath() + " failed.");
        }
    }

    public Writer backupAndOpenWriter(File file) throws IOException, SecurityException {
        this.backup(file);
        return new BufferedWriter(new FileWriter(file));
    }

    public Writer backupAndOpenWriter(File file, String charsetName) throws IOException, SecurityException {
        this.backup(file);
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charsetName));
    }

    public OutputStream backupAndOpenStream(File file) throws IOException, SecurityException {
        this.backup(file);
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    public abstract int getNumBackupsToKeep(File var1);

    public abstract boolean isBackupRequired(File var1);

    public static BackupPolicy noBackups() {
        return new BackupPolicy(){

            public int getNumBackupsToKeep(File file) {
                return 0;
            }

            public boolean isBackupRequired(File file) {
                return false;
            }
        };
    }

    public static BackupPolicy simpleBackups(final int n) {
        return new BackupPolicy(){

            public int getNumBackupsToKeep(File file) {
                return n;
            }

            public boolean isBackupRequired(File file) {
                return true;
            }
        };
    }
}

