/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: ResponseTestServlet.java 62571 2011-04-18 20:58:13Z kgrucci $
 */

/*
 * $URL: https://adc4110351.us.oracle.com/svn/spider/branches/cts/8.0/src/com/sun/ts/tests/servlet/api/common/response/ResponseTestServlet.java $ $LastChangedDate: 2011-04-18 13:58:13 -0700 (Mon, 18 Apr 2011) $
 */

package com.sun.ts.tests.servlet.api.common.response;

import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ResponseTestServlet extends GenericServlet {

    private static final String TEST_HEADER = "testname";

    private static final Class[] TEST_ARGS = {
        ServletRequest.class,
        ServletResponse.class
    };

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse)
      throws ServletException, IOException {
        String test = servletRequest.getParameter(TEST_HEADER).trim();
        try {
            Method method = ResponseTests.class.getMethod(test, TEST_ARGS);
            method.invoke(null, new Object[] { servletRequest, servletResponse });
        } catch (InvocationTargetException ite) {
            throw new ServletException(ite.getTargetException());
        } catch (NoSuchMethodException nsme) {
            throw new ServletException("Test: " + test + " does not exist");
        } catch (Throwable t) {
            throw new ServletException("Error executing test: " + test, t);
        }

    }
}
