/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id:$
 */
package com.sun.ts.tests.servlet.api.javax_servlet.servletcontext31;

import com.sun.ts.tests.servlet.common.servlets.GenericTCKServlet;
import com.sun.ts.tests.servlet.common.util.ServletTestUtil;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.*;

public class TestServlet extends GenericTCKServlet {

    public void getVirtualServerNameTest(ServletRequest request, ServletResponse response)
            throws ServletException, IOException {
        boolean passed = true;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();

        try {
            String expected_virtualhost = request.getParameter("VirtualServerNamePlease");
            String tmp = context.getVirtualServerName();
            if (tmp != null) {
                pw.println("VirtualServerName=" + tmp);
                if (!tmp.equals(expected_virtualhost)) {
                    passed = false;
                    pw.println("Incorrect value returned");
                }
            } else {
                passed = false;
                pw.println("Null value returned");
            }
        } catch (Exception ex) {
            passed = false;
            pw.println("Got Exception when calling getVirtualServerName()");
        }
        ServletTestUtil.printResult(pw, passed);
    }
}
