/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.servlet.api.javax_servlet_http.httpservletrequest40;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;

public class TrailerTestServlet extends HttpServlet {

  @Override
  protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    InputStream in = req.getInputStream();
    int i = 0;
    ByteArrayOutputStream out = new ByteArrayOutputStream();
    while((i = in.read()) != -1){
        out.write(i);
    }

    PrintWriter writer = new PrintWriter(resp.getWriter());

    writer.write("Chunk Data: " + new String(out.toByteArray()));
    writer.println();
    writer.write("isTrailerFieldsReady: " + req.isTrailerFieldsReady());
    writer.println();
    writer.write("Trailer: " + req.getTrailerFields().toString());
    writer.flush();
  }
}
