/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */
package com.sun.ts.tests.servlet.api.javax_servlet_http.httpupgradehandler;

import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.WebConnection;

public class TCKHttpUpgradeHandler implements HttpUpgradeHandler {

    private String delimiter = "/";

    public TCKHttpUpgradeHandler() {
    }

    public void init(WebConnection wc) {
      try {
            ServletInputStream input = wc.getInputStream();
            ServletOutputStream output = wc.getOutputStream();
            TCKReadListener readListener = new TCKReadListener(delimiter, input, output);
            input.setReadListener(readListener);
            output.println("===============TCKHttpUpgradeHandler.init");
            output.flush();
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void destroy() {
        System.out.println("===============destroy");
    }

    public void setDelimiter(String delimiter) {
       System.out.print("=============== setDelimiter"); 
       this.delimiter = delimiter;
    }

    public String getDelimiter() {
        System.out.print("=============== getDelimiter"); 

        return delimiter;
    }
}