/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */
package com.sun.ts.tests.servlet.api.javax_servlet_http.httpupgradehandler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(value = "/TestServlet")
public class TestServlet extends HttpServlet {
  
    public void doPost(HttpServletRequest request,
            HttpServletResponse response)
            throws ServletException, IOException {

        if (request.getHeader("Upgrade")!=null) {
            response.setStatus(101);
            response.setHeader("Upgrade", "YES");
            response.setHeader("Connection", "Upgrade");
            TCKHttpUpgradeHandler handler = request.upgrade(TCKHttpUpgradeHandler.class);
            handler.setDelimiter("/");
        } else {
            response.getWriter().println("No upgrade");
            response.getWriter().println("End of Test");
        }
    }
}
