/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id:$
 */
package com.sun.ts.tests.servlet.spec.defaultcontextpath;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import com.sun.ts.tests.servlet.common.servlets.GenericTCKServlet;
import com.sun.ts.tests.servlet.common.util.ServletTestUtil;


public class TestServlet extends GenericTCKServlet {
    private static final String EXPECTED = "/defaultContextPath";

    public void getDefaultContextPathTest(ServletRequest request,
            ServletResponse response)
            throws ServletException, IOException {
        boolean passed = true;
        PrintWriter pw = response.getWriter();
        String result = this.getServletConfig().getServletContext().getContextPath();
        if ( !result.equals(EXPECTED)) {
            passed = false;
            pw.println("Unexpected context path exists: " + result);
        } 
        ServletTestUtil.printResult(pw, passed);
    }
}
