/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSCUnmatchedSubprotocolClientEndpoint.java 72726 2013-08-28 12:32:42Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.clientendpoint;

import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.client.AnnotatedClientEndpoint;
import com.sun.ts.tests.websocket.common.client.StringClientEndpoint;
import com.sun.ts.tests.websocket.common.util.StringUtil;

@ClientEndpoint(subprotocols = { StringUtil.WEBSOCKET_SUBPROTOCOLS_3,
		StringUtil.WEBSOCKET_SUBPROTOCOLS_4 })
public class WSCUnmatchedSubprotocolClientEndpoint extends
		AnnotatedClientEndpoint<String> {

	public WSCUnmatchedSubprotocolClientEndpoint() {
		super(new StringClientEndpoint());
	}

	@OnMessage
	public void onMessage(String msg) {
		super.onMessage(msg);
	}

	@OnOpen
	public void onOpen(Session session, EndpointConfig config) {
		super.onOpen(session, config);
	}

	@OnClose
	public void onClose(Session session, CloseReason closeReason) {
		super.onClose(session, closeReason);
	}

	@OnError
	public void onError(Session session, Throwable t) {
		super.onError(session, t);
	}

}
