/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.async;

import java.util.concurrent.Future;

import javax.websocket.EndpointConfig;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.client.EndpointCallback;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient.Entity;

public class AsyncEndpointCallback extends EndpointCallback {
	protected Entity entity;

	public AsyncEndpointCallback(Entity entity) {
		super();
		this.entity = entity;
	}	
	@Override
	public void onOpen(Session session, EndpointConfig config) {
		super.onOpen(session, config);
		RemoteEndpoint.Async endpoint = session.getAsyncRemote();
		try {
			Future<Void> future = endpoint.sendObject(entity.getEntityAt(0));
			future.get();
		} catch (Exception i) {
			throw new RuntimeException(i);
		}
	}
}
