/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSCGetTwoParamsServer.java 72308 2013-07-09 10:57:45Z supol $
 */
package com.sun.ts.tests.websocket.ee.javax.websocket.server.handshakerequest;

import java.io.IOException;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.util.IOUtil;

@ServerEndpoint(value = "/gettwoparams/{first}/{second}", configurator = PathParamConfigurator.class)
public class WSCGetTwoParamsServer {
	@OnMessage
	public String onMessage(@PathParam("first") long lng,
			@PathParam("second") double dbl, String msg) {
		return String.valueOf(lng) + ";" + String.valueOf(dbl) + ";" + msg;
	}

	@OnError
	public void onError(Session session, Throwable thr) throws IOException {
		thr.printStackTrace(); // Write to error log, too
		String message = IOUtil.printStackTrace(thr);
		session.getBasicRemote().sendText(message);
	}

}
