/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: ExtensionsConfigurator.java 72735 2013-08-28 16:38:40Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.server.serverendpointconfig.configurator;

import java.util.List;

import javax.websocket.Extension;
import javax.websocket.server.ServerEndpointConfig.Configurator;

import com.sun.ts.tests.websocket.common.impl.ExtensionImpl;

public class ExtensionsConfigurator extends Configurator {

	private static List<ExtensionImpl> installed;
	private static List<ExtensionImpl> requested;
	private static List<ExtensionImpl> resulted;

	@Override
	public List<Extension> getNegotiatedExtensions(List<Extension> installed,
			List<Extension> requested) {
		List<Extension> resulted = super.getNegotiatedExtensions(installed,
				requested);
		ExtensionsConfigurator.setRequested(ExtensionImpl
				.transformToImpl(requested));
		ExtensionsConfigurator.setResulted(ExtensionImpl
				.transformToImpl(resulted));
		ExtensionsConfigurator.setInstalled(ExtensionImpl
				.transformToImpl(installed));
		return resulted;
	}

	static List<ExtensionImpl> getInstalled() {
		return installed;
	}

	static void setInstalled(List<ExtensionImpl> installed) {
		ExtensionsConfigurator.installed = installed;
	}

	static List<ExtensionImpl> getRequested() {
		return requested;
	}

	static void setRequested(List<ExtensionImpl> requested) {
		ExtensionsConfigurator.requested = requested;
	}

	static List<ExtensionImpl> getResulted() {
		return resulted;
	}

	static void setResulted(List<ExtensionImpl> resulted) {
		ExtensionsConfigurator.resulted = resulted;
	}

}
