/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: ModifyHandshakeConfigurator.java 72735 2013-08-28 16:38:40Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.server.serverendpointconfig.configurator;

import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import javax.websocket.server.ServerEndpointConfig.Configurator;

public class ModifyHandshakeConfigurator extends Configurator {
	private static ServerEndpointConfig config;
	private static HandshakeRequest request;
	private static HandshakeResponse response;
	private boolean isCheckedOrigin = false;
	private static boolean isCheckedOriginBeforeModifyHandshake = false;

	@Override
	public boolean checkOrigin(String originHeaderValue) {
		isCheckedOrigin = true;
		return super.checkOrigin(originHeaderValue);
	}

	@Override
	public void modifyHandshake(ServerEndpointConfig sec,
			HandshakeRequest request, HandshakeResponse response) {
		ModifyHandshakeConfigurator
				.setCheckedOriginBeforeModifyHandshake(isCheckedOrigin);
		ModifyHandshakeConfigurator.setConfig(sec);
		ModifyHandshakeConfigurator.setRequest(request);
		ModifyHandshakeConfigurator.setResponse(response);
		super.modifyHandshake(sec, request, response);
	}

	static ServerEndpointConfig getConfig() {
		return config;
	}

	static HandshakeRequest getRequest() {
		return request;
	}

	static HandshakeResponse getResponse() {
		return response;
	}

	static boolean isCheckedOriginBeforeModifyHandshake() {
		return isCheckedOriginBeforeModifyHandshake;
	}

	private static void setConfig(ServerEndpointConfig config) {
		ModifyHandshakeConfigurator.config = config;
	}

	private static void setRequest(HandshakeRequest request) {
		ModifyHandshakeConfigurator.request = request;
	}

	private static void setResponse(HandshakeResponse response) {
		ModifyHandshakeConfigurator.response = response;
	}

	private static void setCheckedOriginBeforeModifyHandshake(
			boolean isCheckedOriginBeforeModifyHandshake) {
		ModifyHandshakeConfigurator.isCheckedOriginBeforeModifyHandshake = isCheckedOriginBeforeModifyHandshake;
	}
}
