/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: ByteArrayPartialMessageHandler.java 73928 2014-08-01 09:35:37Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.session11.client;

import javax.websocket.MessageHandler;

public class ByteArrayPartialMessageHandler implements
		MessageHandler.Partial<byte[]> {

	MixedProgramaticEndpoint endpoint;
	public static final String HANDLER_SAYS = "ByteArrayPartialMessageHandler says: ";
	StringBuilder sb = new StringBuilder();

	public ByteArrayPartialMessageHandler(MixedProgramaticEndpoint endpoint) {
		super();
		this.endpoint = endpoint;
	}

	@Override
	public void onMessage(byte[] message, boolean finite) {
		sb.append(new String(message));
		if (finite)
			endpoint.onMessage(HANDLER_SAYS + sb.toString());
	}
}
