/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: StringListWholeMessageHandler.java 73928 2014-08-01 09:35:37Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.session11.server;

import java.io.IOException;

import javax.websocket.MessageHandler;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.ee.javax.websocket.session11.common.StringList;

public class StringListWholeMessageHandler implements
		MessageHandler.Whole<StringList> {

	private Session session;
	public static final String HANDLER_SAYS = "StringListWholeMessageHandler says: ";

	public StringListWholeMessageHandler(Session session) {
		super();
		this.session = session;
	}

	@Override
	public void onMessage(StringList message) {
		try {
			session.getBasicRemote().sendText(
					HANDLER_SAYS + message.get(0).toString());
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}
}
