/*
 * Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: OnErrorServerEndpoint.java 74522 2015-06-02 12:05:10Z jsupol $
 */

package com.sun.ts.tests.websocket.negdep.invalidpathparamtype.pasrv.onerror;

import java.io.IOException;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextDecoder;

@ServerEndpoint(value = "/invalid/{arg}", decoders = { StringBeanTextDecoder.class })
public class OnErrorServerEndpoint {
	private static String exception = "";

	@OnMessage
	public String echo(String echo) {
		if ("throw".equals(echo))
			throw new RuntimeException(echo);
		return exception + echo;
	}

	// This header makes the endpoint invalid, since only Strings can be
	// @PathParams
	@OnError
	public void onError(Session session, Throwable t,
			@PathParam("arg") StringBean sb) throws IOException {
		exception = sb.get();
		session.getBasicRemote().sendText(t.getMessage());
	}
}
