/*
 * Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: OnErrorStringHolderServerEndpoint.java 74491 2015-05-18 14:51:46Z jsupol $
 */

package com.sun.ts.tests.websocket.negdep.invalidpathparamtype.srv.onerror;

import java.io.IOException;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.negdep.StringHolder;

@ServerEndpoint("/invalid/{arg}")
public class OnErrorStringHolderServerEndpoint {
	private static String exception = "";

	@OnMessage
	public String echo(String echo) {
		if ("throw".equals(echo))
			throw new RuntimeException(echo);
		return exception + echo;
	}

	@OnError
	public void onError(Session session, Throwable t,
			@PathParam("arg") StringHolder sb) throws IOException {
		exception = sb.toString();
		session.getBasicRemote().sendText(t.getMessage());
	}
}
