/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: WSTestServerPathParam.java 71462 2013-04-08 04:27:50Z djiao $
 */
package com.sun.ts.tests.websocket.spec.servercontainer.addendpoint;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

@ServerEndpoint(value ="/TCKTestServerPathParam/{param1}/{param2}")
public class WSTestServerPathParam {

        @OnOpen
        public void init(Session session) throws IOException {
                String message = "========WSTestServerPathParam opened";
                session.getBasicRemote().sendText(message);
        }

        @OnMessage
        public void respond(String message, Session session) {
                System.out.println("========WSTestServerPathParam received String:" + message);
                StringBuffer sb = new StringBuffer();

                try {
                        session.getBasicRemote().sendText(
                                "========WSTestServerPathParam received String: " + message);
                        Map<String, String> pathparams = session.getPathParameters();
                        Set<String> keys = pathparams.keySet();
                        for (Object key : keys) {
                                System.out.println(";" + key.toString() + "="
                                        + pathparams.get(key.toString()));
                                sb.append(";" + key.toString() + "="
                                        + pathparams.get(key.toString()));
                        }
                        session.getBasicRemote().sendText(
                                "========WSTestServerPathParam: pathparams returned"
                                + sb.toString());
                } catch (Exception ex) {
                        ex.printStackTrace();
                }
        }

        @OnError
        public void onError(Session session, Throwable t) {
                System.out.println("WSTestServerPathParam onError");
                try {
                        session.getBasicRemote().sendText(
                                "========WSTestServerPathParam onError");
                } catch (Exception e) {
                        e.printStackTrace();
                }
                t.printStackTrace();
        }
}