/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.core;

import com.sun.tdk.signaturetest.core.ClassHierarchy;
import com.sun.tdk.signaturetest.model.ClassDescription;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ClassSet {
    private ClassHierarchy hierarchy;
    private boolean trackDependeces;
    private Map classNamesInProcess = new HashMap();
    private Map<String, Counter> classes = new HashMap<String, Counter>();
    private Set<String> missingClasses = new HashSet<String>();

    public ClassSet(ClassHierarchy hierarchy, boolean trackDependeces) {
        this.hierarchy = hierarchy;
        this.trackDependeces = trackDependeces;
    }

    public void addClass(String fqname) {
        this.addClass(fqname, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClass(String fqname, boolean externalCall) {
        block10: {
            if (this.classNamesInProcess.get(fqname) != null) {
                return;
            }
            this.classNamesInProcess.put(fqname, null);
            try {
                Counter counter = this.classes.get(fqname);
                try {
                    ClassDescription cl = this.hierarchy.load(fqname);
                    if (!(this.hierarchy.isAccessible(cl) || externalCall || cl.isInterface())) {
                        this.addClass(cl.getSuperClass().getQualifiedName(), false);
                    }
                    if (counter == null) {
                        this.classes.put(fqname, new Counter(0));
                        if (this.trackDependeces) {
                            Set dep = cl.getDependences();
                            Iterator i = dep.iterator();
                            while (i.hasNext()) {
                                this.addClass((String)i.next(), false);
                            }
                        }
                        break block10;
                    }
                    counter.increment();
                }
                catch (ClassNotFoundException e) {
                    this.missingClasses.add(fqname);
                }
            }
            finally {
                this.classNamesInProcess.remove(fqname);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClass(String fqname) {
        block10: {
            if (this.classNamesInProcess.get(fqname) != null) {
                return;
            }
            this.classNamesInProcess.put(fqname, null);
            try {
                Counter counter = this.classes.get(fqname);
                if (counter == null) break block10;
                int c = counter.intValue();
                if (c == 0) {
                    this.classes.remove(fqname);
                    try {
                        ClassDescription cl = this.hierarchy.load(fqname);
                        Set dep = cl.getDependences();
                        Iterator i = dep.iterator();
                        while (i.hasNext()) {
                            this.removeClass((String)i.next());
                        }
                        break block10;
                    }
                    catch (ClassNotFoundException e) {
                        assert (this.missingClasses.contains(fqname));
                        break block10;
                    }
                }
                assert (c > 0);
                counter.decrement();
            }
            finally {
                this.classNamesInProcess.remove(fqname);
            }
        }
    }

    public Set<String> getClasses() {
        return Collections.unmodifiableSet(this.classes.keySet());
    }

    public Set<String> getMissingClasses() {
        return Collections.unmodifiableSet(this.missingClasses);
    }

    private static final class Counter {
        int count;

        Counter(int c) {
            this.count = c;
        }

        void increment() {
            ++this.count;
        }

        void decrement() {
            --this.count;
        }

        int intValue() {
            return this.count;
        }
    }
}

