/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.BasicParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestEnvContext;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestSuite;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.Properties;
import com.sun.javatest.util.StringArray;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class FileParameters
extends BasicParameters
implements Parameters.LegacyEnvParameters {
    private File[] envFiles;
    private File[] cachedAbsEnvFiles;
    private File cachedAbsEnvFiles_base;
    private File[] cachedAbsEnvFiles_envFiles;
    private String envName;
    private TestEnvContext cachedEnvTable;
    private File[] cachedEnvTable_absEnvFiles;
    private String envTableError;
    private TestEnvironment cachedEnv;
    private TestEnvContext cachedEnv_envTable;
    private String cachedEnv_envName;
    private String envError;
    private File reportDir;
    private String legacyTsPath;
    private static final String PARAMFILE_EXTN = ".jtp";
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(FileParameters.class);

    public static boolean isParameterFile(File file) {
        return file.getPath().endsWith(PARAMFILE_EXTN);
    }

    public FileParameters() {
    }

    public FileParameters(File file) throws FileNotFoundException, IOException {
        Properties p = new Properties();
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        p.load(in);
        ((Reader)in).close();
        this.setTestSuite(this.adjustPath(p.getProperty("javasoft.sqe.javatest.selection.testSuite")));
        this.setWorkDirectory(p.getProperty("javasoft.sqe.javatest.results.workDir"));
        this.setTests(p.getProperty("javasoft.sqe.javatest.selection.tests"));
        this.setExcludeFiles(p.getProperty("javasoft.sqe.javatest.selection.excludeList"));
        String keywordOp = p.getProperty("javasoft.sqe.javatest.selection.keywordOp");
        String keywords = p.getProperty("javasoft.sqe.javatest.selection.keywords");
        this.setKeywords(keywordOp, keywords);
        String statusOp = p.getProperty("javasoft.sqe.javatest.selection.status");
        String[] statusTests = new String[]{p.getProperty("javasoft.sqe.javatest.selection.prev.passed"), p.getProperty("javasoft.sqe.javatest.selection.prev.failed"), p.getProperty("javasoft.sqe.javatest.selection.prev.error"), p.getProperty("javasoft.sqe.javatest.selection.prev.notRun")};
        this.setPriorStatusValues(statusOp, statusTests);
        this.setEnvFiles(p.getProperty("javasoft.sqe.javatest.execution.envFiles"));
        this.setEnvName(p.getProperty("javasoft.sqe.javatest.execution.environment"));
        this.setConcurrency(p.getProperty("javasoft.sqe.javatest.execution.concurrency"));
        this.setTimeoutFactor(p.getProperty("javasoft.sqe.javatest.execution.timeFactor"));
        this.setReportDir(p.getProperty("javasoft.sqe.javatest.results.reportDir"));
    }

    public FileParameters(String[] args) {
        String testSuiteArg = null;
        String workDirArg = null;
        String testsArgs = null;
        String exclFilesArgs = null;
        String keywordsExprArg = null;
        String priorStatusValuesArg = null;
        String envFilesArgs = null;
        String envNameArg = null;
        String concurrencyArg = null;
        String timeoutFactorArg = null;
        String reportDirArg = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-testSuite".equalsIgnoreCase(args[i]) || "-t".equalsIgnoreCase(args[i])) {
                testSuiteArg = args[++i];
                continue;
            }
            if ("-keywords".equalsIgnoreCase(args[i])) {
                keywordsExprArg = args[++i];
                continue;
            }
            if ("-status".equalsIgnoreCase(args[i])) {
                priorStatusValuesArg = args[++i].toLowerCase();
                continue;
            }
            if ("-exclude".equalsIgnoreCase(args[i])) {
                if (exclFilesArgs == null) {
                    exclFilesArgs = args[++i];
                    continue;
                }
                exclFilesArgs = exclFilesArgs + " " + args[++i];
                continue;
            }
            if ("-envFile".equalsIgnoreCase(args[i])) {
                if (envFilesArgs == null) {
                    envFilesArgs = args[++i];
                    continue;
                }
                envFilesArgs = envFilesArgs + " " + args[++i];
                continue;
            }
            if ("-env".equalsIgnoreCase(args[i])) {
                envNameArg = args[++i];
                continue;
            }
            if ("-concurrency".equalsIgnoreCase(args[i])) {
                concurrencyArg = args[++i];
                continue;
            }
            if ("-timeoutFactor".equalsIgnoreCase(args[i])) {
                timeoutFactorArg = args[++i];
                continue;
            }
            if ("-report".equalsIgnoreCase(args[i]) || "-r".equalsIgnoreCase(args[i])) {
                reportDirArg = args[++i];
                continue;
            }
            if ("-workDir".equalsIgnoreCase(args[i]) || "-w".equalsIgnoreCase(args[i])) {
                workDirArg = args[++i];
                continue;
            }
            if (args[i].startsWith("-")) {
                throw new IllegalArgumentException(args[i]);
            }
            String[] tests = new String[args.length - i];
            System.arraycopy(args, i, tests, 0, tests.length);
            testsArgs = StringArray.join(tests);
            i = args.length;
        }
        this.setTestSuite(this.adjustPath(testSuiteArg));
        this.setWorkDirectory(this.adjustPath(workDirArg));
        this.setTests(testsArgs);
        this.setExcludeFiles(exclFilesArgs);
        this.setKeywords("expr", keywordsExprArg);
        this.setPriorStatusValues(priorStatusValuesArg);
        this.setEnvFiles(envFilesArgs);
        this.setEnvName(envNameArg);
        this.setConcurrency(concurrencyArg);
        this.setTimeoutFactor(timeoutFactorArg);
        this.setReportDir(this.adjustPath(reportDirArg));
    }

    @Override
    public Parameters.EnvParameters getEnvParameters() {
        return this;
    }

    @Override
    public File[] getEnvFiles() {
        return this.envFiles;
    }

    @Override
    public File[] getAbsoluteEnvFiles() {
        this.updateAbsoluteEnvFiles();
        return this.cachedAbsEnvFiles;
    }

    @Override
    public void setEnvFiles(File[] files) {
        this.envFiles = files;
    }

    private void setEnvFiles(String files) {
        String[] f = StringArray.split(files);
        File[] ff = new File[f.length];
        for (int i = 0; i < ff.length; ++i) {
            ff[i] = new File(this.makeLegacyTsRelative(f[i]));
        }
        this.setEnvFiles(ff);
    }

    @Override
    public String getEnvName() {
        return this.envName;
    }

    @Override
    public void setEnvName(String name) {
        this.envName = name;
    }

    public TestEnvContext getEnvTable() {
        this.updateEnvTable();
        return this.cachedEnvTable;
    }

    @Override
    public TestEnvironment getEnv() {
        this.updateEnv();
        return this.cachedEnv;
    }

    private void updateAbsoluteEnvFiles() {
        File base;
        TestSuite ts = this.getTestSuite();
        File file = base = ts == null ? null : ts.getRootDir();
        if (this.cachedAbsEnvFiles == null || this.cachedAbsEnvFiles_base != base || this.cachedAbsEnvFiles_envFiles != this.envFiles) {
            this.cachedAbsEnvFiles = FileParameters.getAbsoluteFiles(base, this.envFiles);
        }
    }

    private void updateEnvTable() {
        this.updateAbsoluteEnvFiles();
        File[] absEnvFiles = this.cachedAbsEnvFiles;
        if (this.cachedEnvTable == null || !FileParameters.equal(absEnvFiles, this.cachedEnvTable_absEnvFiles)) {
            try {
                this.cachedEnvTable = new TestEnvContext(absEnvFiles);
                this.cachedEnvTable_absEnvFiles = absEnvFiles;
                this.envTableError = null;
            }
            catch (TestEnvContext.Fault e) {
                this.cachedEnvTable = null;
                this.envTableError = e.getMessage();
            }
        }
    }

    private void updateEnv() {
        TestEnvironment env;
        TestEnvContext envTable = this.getEnvTable();
        if (envTable == null) {
            this.cachedEnv = null;
            this.envError = i18n.getString("fp.noEnvs", this.envName);
            return;
        }
        try {
            if (this.envName == null) {
                this.envName = "";
            }
            if ((env = envTable.getEnv(this.envName)) == null) {
                this.cachedEnv = null;
                this.envError = i18n.getString("fp.envNotFound", this.envName);
                return;
            }
            for (TestEnvironment.Element entry : env.elements()) {
                if (entry.value.indexOf("VALUE_NOT_DEFINED") < 0) continue;
                String eText = (entry.definedInEnv == null ? "" : "env." + entry.definedInEnv + ".") + entry.key + "=" + entry.value;
                this.cachedEnv = null;
                this.envError = i18n.getString("fp.undefinedEntry", new Object[]{eText, entry.definedInFile});
                return;
            }
        }
        catch (TestEnvironment.Fault e) {
            this.cachedEnv = null;
            this.envError = i18n.getString("fp.badEnv", new Object[]{this.envName, e.getMessage()});
            return;
        }
        this.cachedEnv = env;
        this.envError = null;
    }

    private boolean isEnvOK() {
        this.updateEnv();
        return this.envTableError == null && this.envError == null;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.isEnvOK();
    }

    @Override
    public String getErrorMessage() {
        String basicError = super.getErrorMessage();
        return basicError != null ? basicError : (this.envTableError != null ? this.envTableError : null);
    }

    private void setTestSuite(String path) {
        File p;
        this.legacyTsPath = path;
        File file = p = path == null ? null : new File(path);
        if (p != null && p.isFile()) {
            this.legacyTsPath = p.getParent();
        }
        if (p == null || TestSuite.isTestSuite(p)) {
            this.setTestSuite(p);
        } else {
            File parent = p.getParentFile();
            if (parent != null && TestSuite.isTestSuite(parent)) {
                this.setTestSuite(parent);
            } else {
                this.setTestSuite(p);
            }
        }
    }

    private void setWorkDirectory(String path) {
        this.setWorkDirectory(path == null ? null : new File(path));
    }

    private void setTests(String tests) {
        this.setTests(StringArray.split(tests));
    }

    private void setExcludeFiles(String files) {
        String[] f = StringArray.split(files);
        File[] ff = new File[f.length];
        for (int i = 0; i < ff.length; ++i) {
            ff[i] = new File(this.makeLegacyTsRelative(f[i]));
        }
        this.setExcludeFiles(ff);
    }

    private void setKeywords(String op, String value) {
        if (op == null || op.equals("ignore")) {
            this.setKeywordsMode(1);
        } else if (op.equals("expr")) {
            this.setKeywords(3, value);
        } else if (op.equals("allOf")) {
            this.setKeywords(2, value);
        } else if (op.equals("anyOf")) {
            this.setKeywords(1, value);
        } else {
            this.setKeywordsMode(1);
        }
    }

    private void setPriorStatusValues(String op, String[] values) {
        if (op == null || !op.equals("allOf")) {
            this.setPriorStatusValues((boolean[])null);
        } else {
            boolean[] b = new boolean[4];
            for (int i = 0; i < values.length; ++i) {
                b[i] = "true".equals(values[i]);
            }
            this.setPriorStatusValues(b);
        }
    }

    private void setPriorStatusValues(String values) {
        if (values == null || values.length() == 0) {
            this.setPriorStatusValues((boolean[])null);
        } else {
            boolean[] b = new boolean[]{values.indexOf("pass") != -1, values.indexOf("fail") != -1, values.indexOf("erro") != -1, values.indexOf("notr") != -1};
            this.setPriorStatusValues(b);
        }
    }

    private void setConcurrency(String conc) {
        if (conc == null) {
            this.setConcurrency(1);
        } else {
            try {
                this.setConcurrency(Integer.parseInt(conc));
            }
            catch (NumberFormatException e) {
                this.concurrencyError = i18n.getString("fp.badConcurrency", conc);
            }
        }
    }

    private void setTimeoutFactor(String tf) {
        if (tf == null) {
            this.setTimeoutFactor(1.0f);
        } else {
            try {
                this.setTimeoutFactor(Float.parseFloat(tf));
            }
            catch (NumberFormatException e) {
                this.timeoutFactorError = i18n.getString("fp.badTimeoutFactor", tf);
            }
        }
    }

    public File getReportDir() {
        return this.reportDir;
    }

    public void setReportDir(File dir) {
        this.reportDir = dir;
    }

    private void setReportDir(String dir) {
        if (dir == null) {
            this.setReportDir((File)null);
        } else {
            this.setReportDir(new File(dir));
        }
    }

    private String adjustPath(String path) {
        if (path == null) {
            return path;
        }
        File p = new File(path);
        if (p.isAbsolute()) {
            return path;
        }
        String userDir = System.getProperty("user.dir");
        if (userDir == null) {
            return path;
        }
        return userDir + File.separator + path;
    }

    private String makeLegacyTsRelative(String path) {
        if (path == null) {
            return path;
        }
        File p = new File(path);
        if (p.isAbsolute()) {
            return path;
        }
        if (this.legacyTsPath == null) {
            return path;
        }
        return this.legacyTsPath + File.separator + path;
    }
}

