/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.tck.tests.binding.base;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mvcspec.tck.tests.binding.base.BindingBaseController;
import org.mvcspec.tck.tests.binding.base.BindingBaseForm;
import org.mvcspec.tck.util.Archives;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class BindingBaseTest {
    @ArquillianResource
    private URL baseUrl;
    private WebClient webClient;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive().addClass(BindingBaseController.class).addClass(BindingBaseForm.class).addView("binding/base/form.jsp").addView("binding/base/result.jsp").build();
    }

    @Before
    public void before() {
        this.webClient = new WebClient();
        this.webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        this.webClient.getOptions().setRedirectEnabled(false);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="mvc_binding_annotation", id="mvc-binding"), @SpecAssertion(section="error_handling_bindingresult", id="inject-binding-result")})
    public void submitValidValue() throws IOException {
        HtmlPage resultPage = this.submitForm("20");
        Assert.assertThat((Object)resultPage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)resultPage.getElementById("message").getTextContent().trim(), (Matcher)CoreMatchers.startsWith((String)"You are 20 years old"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="mvc_binding_annotation", id="mvc-binding"), @SpecAssertion(section="error_handling_bindingresult", id="invoke-controller"), @SpecAssertion(section="error_handling_bindingresult", id="inject-binding-result")})
    public void submitValidationError() throws IOException {
        HtmlPage resultPage = this.submitForm("12");
        Assert.assertThat((Object)resultPage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)resultPage.getElementById("message").getTextContent().trim(), (Matcher)CoreMatchers.startsWith((String)"Validation error: You are too young"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="mvc_binding_annotation", id="mvc-binding"), @SpecAssertion(section="error_handling_bindingresult", id="invoke-controller"), @SpecAssertion(section="error_handling_bindingresult", id="inject-binding-result")})
    public void submitBindingError() throws IOException {
        HtmlPage resultPage = this.submitForm("foobar");
        Assert.assertThat((Object)resultPage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)resultPage.getElementById("message").getTextContent().trim(), (Matcher)CoreMatchers.startsWith((String)"Binding error"));
    }

    private HtmlPage submitForm(String value) throws IOException {
        HtmlPage formPage = (HtmlPage)this.webClient.getPage(this.baseUrl.toString() + "mvc/binding/base");
        Assert.assertThat((Object)formPage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        HtmlElement ageInput = (HtmlElement)formPage.getElementById("age-input");
        ageInput.type(value);
        return (HtmlPage)formPage.getElementById("submit-btn").click();
    }
}

