/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.junit;

import org.jboss.arquillian.junit.State;
import org.jboss.arquillian.test.spi.TestRunnerAdaptor;
import org.jboss.arquillian.test.spi.TestRunnerAdaptorBuilder;

abstract class AdaptorManager {
    AdaptorManager() {
    }

    void initializeAdaptor() throws Exception {
        if (!State.hasTestAdaptor()) {
            if (State.hasInitializationException()) {
                this.handleSuiteLevelFailure(State.getInitializationException());
            } else {
                try {
                    TestRunnerAdaptor adaptor = TestRunnerAdaptorBuilder.build();
                    adaptor.beforeSuite();
                    State.testAdaptor(adaptor);
                }
                catch (Exception e) {
                    State.caughtInitializationException(e);
                    this.handleBeforeSuiteFailure(e);
                }
            }
        }
        if (State.hasTestAdaptor()) {
            this.setAdaptor(State.getTestAdaptor());
        }
    }

    void shutdown(TestRunnerAdaptor adaptor) {
        State.runnerFinished();
        try {
            if (State.isLastRunner()) {
                try {
                    if (adaptor != null) {
                        adaptor.afterSuite();
                        adaptor.shutdown();
                    }
                }
                finally {
                    State.clean();
                }
            }
            this.setAdaptor(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not run @AfterSuite", e);
        }
    }

    protected abstract void handleSuiteLevelFailure(Throwable var1);

    protected abstract void handleBeforeSuiteFailure(Exception var1) throws Exception;

    protected abstract void setAdaptor(TestRunnerAdaptor var1);

    protected abstract TestRunnerAdaptor getAdaptor();
}

