/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.platform;

import com.gargoylesoftware.htmlunit.platform.XmlUtilsHelperAPI;
import com.gargoylesoftware.htmlunit.platform.canvas.rendering.NoOpRenderingBackend;
import com.gargoylesoftware.htmlunit.platform.canvas.rendering.RenderingBackend;
import com.gargoylesoftware.htmlunit.platform.image.ImageData;
import com.gargoylesoftware.htmlunit.platform.image.NoOpImageData;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class Platform {
    private static XmlUtilsHelperAPI HelperXerces_;
    private static XmlUtilsHelperAPI HelperSunXerces_;

    public static int getIndex(NamedNodeMap namedNodeMap, Map<Integer, List<String>> attributesOrderMap, Node element, int requiredIndex) {
        int result;
        if (HelperXerces_ != null && (result = HelperXerces_.getIndex(namedNodeMap, attributesOrderMap, element, requiredIndex)) != -1) {
            return result;
        }
        if (HelperSunXerces_ != null && (result = HelperSunXerces_.getIndex(namedNodeMap, attributesOrderMap, element, requiredIndex)) != -1) {
            return result;
        }
        return requiredIndex;
    }

    public static Map<Integer, List<String>> getAttributesOrderMap(Document document) {
        Map<Integer, List<String>> result;
        if (HelperXerces_ != null && (result = HelperXerces_.getAttributesOrderMap(document)) != null) {
            return result;
        }
        if (HelperSunXerces_ != null && (result = HelperSunXerces_.getAttributesOrderMap(document)) != null) {
            return result;
        }
        return new HashMap<Integer, List<String>>();
    }

    public static RenderingBackend getRenderingBackend(int imageWidth, int imageHeight) {
        try {
            Class<?> backendClass = Class.forName("com.gargoylesoftware.htmlunit.platform.canvas.rendering.AwtRenderingBackend");
            return (RenderingBackend)ConstructorUtils.invokeConstructor(backendClass, (Object[])new Object[]{imageWidth, imageHeight});
        }
        catch (Exception e) {
            return new NoOpRenderingBackend(imageWidth, imageHeight);
        }
    }

    public static ImageData buildImageData(InputStream inputStream) throws IOException {
        try {
            Class<?> backendClass = Class.forName("com.gargoylesoftware.htmlunit.platform.image.ImageIOImageData");
            return (ImageData)ConstructorUtils.invokeConstructor(backendClass, (Object[])new Object[]{inputStream});
        }
        catch (InvocationTargetException e) {
            Throwable targetEx = e.getTargetException();
            if (targetEx instanceof IOException) {
                throw (IOException)e.getTargetException();
            }
            return new NoOpImageData();
        }
        catch (Exception ex) {
            return new NoOpImageData();
        }
    }

    private Platform() {
    }

    static {
        try {
            HelperSunXerces_ = (XmlUtilsHelperAPI)Class.forName("com.gargoylesoftware.htmlunit.platform.util.XmlUtilsSunXercesHelper").newInstance();
        }
        catch (Exception | LinkageError throwable) {
            // empty catch block
        }
        try {
            HelperXerces_ = (XmlUtilsHelperAPI)Class.forName("com.gargoylesoftware.htmlunit.platform.util.XmlUtilsXercesHelper").newInstance();
        }
        catch (Exception | LinkageError throwable) {
            // empty catch block
        }
    }
}

