/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.xml.dtm.ref;

import net.sourceforge.htmlunit.xpath.xml.dtm.DTMIterator;
import net.sourceforge.htmlunit.xpath.xml.utils.WrappedRuntimeException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class DTMNodeIterator
implements NodeIterator {
    private final DTMIterator dtm_iter;
    private boolean valid = true;

    public DTMNodeIterator(DTMIterator dtmIterator) {
        try {
            this.dtm_iter = (DTMIterator)dtmIterator.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new WrappedRuntimeException(cnse);
        }
    }

    @Override
    public void detach() {
        this.valid = false;
    }

    @Override
    public boolean getExpandEntityReferences() {
        return false;
    }

    @Override
    public NodeFilter getFilter() {
        throw new DOMException(9, "");
    }

    @Override
    public Node getRoot() {
        int handle = this.dtm_iter.getRoot();
        return this.dtm_iter.getDTM(handle).getNode(handle);
    }

    @Override
    public int getWhatToShow() {
        return this.dtm_iter.getWhatToShow();
    }

    @Override
    public Node nextNode() throws DOMException {
        if (!this.valid) {
            throw new DOMException(11, "");
        }
        int handle = this.dtm_iter.nextNode();
        if (handle == -1) {
            return null;
        }
        return this.dtm_iter.getDTM(handle).getNode(handle);
    }

    @Override
    public Node previousNode() {
        if (!this.valid) {
            throw new DOMException(11, "");
        }
        int handle = this.dtm_iter.previousNode();
        if (handle == -1) {
            return null;
        }
        return this.dtm_iter.getDTM(handle).getNode(handle);
    }
}

