/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.mvc.tests.binding.numeric;

import com.gargoylesoftware.htmlunit.Page;
import ee.jakarta.tck.mvc.tests.binding.numeric.AbstractNumericTest;
import ee.jakarta.tck.mvc.tests.binding.numeric.BindingBigDecimalController;
import ee.jakarta.tck.mvc.tests.binding.numeric.BindingBigDecimalForm;
import ee.jakarta.tck.mvc.tests.binding.numeric.ForceGermanLocaleResolver;
import ee.jakarta.tck.mvc.util.Archives;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class BindingBigDecimalTest
extends AbstractNumericTest {
    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive().addClass(ForceGermanLocaleResolver.class).addClass(BindingBigDecimalController.class).addClass(BindingBigDecimalForm.class).addView("binding/numeric/form.jsp").addView("binding/numeric/result.jsp").build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="numeric_types", id="convert-numeric")})
    public void submitValidBigDecimal() throws IOException {
        Page resultPage = this.submitForm("binding/numeric", "1.234,56");
        Assert.assertThat((Object)resultPage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)resultPage.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Object: [1234.56]"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="numeric_types", id="convert-empty-numeric")})
    public void submitEmptyBigDecimal() throws IOException {
        Page resultPage = this.submitForm("binding/numeric", "");
        Assert.assertThat((Object)resultPage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)resultPage.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Object: [null]"));
    }
}

