/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.api.jakarta_servlet.jsp.pagecontext;

import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import ee.jakarta.tck.pages.common.util.JspTestUtil;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    public URLClientIT() throws Exception {
        this.setTestJsp("PageContextTest");
        this.setContextRoot("/jsp_pagecontext_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_pagecontext_web.war");
        archive.addClasses(new Class[]{JspTestUtil.class});
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_pagecontext_web.xml"));
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/PageContextTest.jsp")), "PageContextTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/ErrorPage.jsp")), "ErrorPage.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/Resource.jsp")), "Resource.jsp");
        return archive;
    }

    @Test
    public void pageContextGetSessionTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextGetSessionTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextGetPageTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextGetPageTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextGetRequestTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextGetRequestTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextGetResponseTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextGetResponseTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextGetExceptionTest() throws Exception {
        TEST_PROPS.setProperty("testname", "pageContextGetExceptionTest");
        TEST_PROPS.setProperty("request", "GET /jsp_pagecontext_web/PageContextTest.jsp?testname=pageContextGetExceptionTest HTTP/1.1");
        TEST_PROPS.setProperty("ignore_status_code", "true");
        TEST_PROPS.setProperty("search_string", "Test PASSED (getException)");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextGetServletConfigTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextGetServletConfigTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextGetServletContextTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextGetServletContextTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextForwardContextPathTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextForwardContextPathTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextForwardPagePathTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextForwardPagePathTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextForwardIllegalStateExceptionTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_pagecontext_web/PageContextTest.jsp?testname=pageContextForwardIllegalStateExceptionTest HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Arbitrary text|Test PASSED");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextIncludeContextPathTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextIncludeContextPathTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextIncludePagePathTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextIncludePagePathTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextIncludeFlushTrueTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextIncludeFlushTrueTest");
        TEST_PROPS.setProperty("search_string", "Stream was properly flushed");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextIncludeFlushFalseTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextIncludeFlushFalseTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Test PASSED.|Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextHandlePageExceptionExcTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextHandlePageExceptionExcTest");
        TEST_PROPS.setProperty("ignore_status_code", "true");
        TEST_PROPS.setProperty("search_string", "java.lang.RuntimeException");
        this.invoke();
    }

    @Test
    public void pageContextHandlePageExceptionThrTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextHandlePageExceptionThrTest");
        TEST_PROPS.setProperty("ignore_status_code", "true");
        TEST_PROPS.setProperty("search_string", "java.lang.Throwable");
        this.invoke();
    }

    @Test
    public void pageContextHandlePageExceptionExcNPETest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextHandlePageExceptionExcNPETest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextHandlePageExceptionThrNPETest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextHandlePageExceptionThrNPETest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextPushPopBodyTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextPushPopBodyTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextGetErrorDataTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextGetErrorDataTest");
        TEST_PROPS.setProperty("ignore_status_code", "true");
        TEST_PROPS.setProperty("search_string", "ErrorData object obtained");
        this.invoke();
    }

    @Test
    public void pageContextIncludeIOExceptionTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextIncludeIOExceptionTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextIncludeServletExceptionTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextIncludeServletExceptionTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextIncludeFlushIOExceptionTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextIncludeFlushIOExceptionTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextIncludeFlushServletExceptionTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextIncludeFlushServletExceptionTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextGetSetAttributeTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextGetSetAttributeTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextSetAttributeNPETest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextSetAttributeNPETest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextGetSetAttributeInScopeTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextGetSetAttributeInScopeTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextSetAttributeInScopeNPETest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextSetAttributeInScopeNPETest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextSetAttributeInScopeIllegalArgumentExceptionTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextSetAttributeInScopeIllegalArgumentExcTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextGetAttributeNPETest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextGetAttributeNPETest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextGetAttributeInScopeIllegalArgumentExceptionTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextGetAttributeInScopeIllegalArgumentExceptionTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextFindAttributeTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextFindAttributeTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextRemoveAttributeTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextRemoveAttributeTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextRemoveAttributeFromScopeTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextRemoveAttributeFromScopeTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextRemoveAttributeFromScopeIllegalScopeTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextRemoveAttributeFromScopeIllegalScopeTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextGetAttributeScopeTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextGetAttributeScopeTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextGetAttributeNamesInScopeTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextGetAttributeNamesInScopeTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextGetAttributeNamesInScopeIllegalScopeTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextGetAttributeNamesInScopeIllegalScopeTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextGetOutTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextGetOutTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextFindAttributeNullNameTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextFindAttributeNullNameTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextGetAttributesScopeNullNameTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextGetAttributesScopeNullNameTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextRemoveAttributeNullNameTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextRemoveAttributeNullNameTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }

    @Test
    public void pageContextSetAttributeNullValueTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "pageContextSetAttributeNullValueTest");
        TEST_PROPS.setProperty("unexpected_response_match", "Error page invoked");
        this.invoke();
    }
}

