/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.tagsupport;

import ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.tagsupport.ContainerInteractionTag;
import ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.tagsupport.FindAncestorTag;
import ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.tagsupport.InitializationTag;
import ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.tagsupport.ParentTag;
import ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.tagsupport.SynchronizationTag;
import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import ee.jakarta.tck.pages.common.util.JspTestUtil;
import ee.jakarta.tck.pages.common.util.MethodValidatorBean;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    public URLClientIT() throws Exception {
        this.setContextRoot("/jsp_tagsupport_web");
        this.setTestJsp("TagSupportApiTest");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_tagsupport_web.war");
        archive.addClasses(new Class[]{ContainerInteractionTag.class, FindAncestorTag.class, InitializationTag.class, ParentTag.class, SynchronizationTag.class, JspTestUtil.class, MethodValidatorBean.class});
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_tagsupport_web.xml"));
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tagsupport.tld", "tagsupport.tld");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/DoAfterBodyEvalBodyAgainTest.jsp")), "DoAfterBodyEvalBodyAgainTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/DoAfterBodySkipBodyTest.jsp")), "DoAfterBodySkipBodyTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/DoEndTagEvalPageTest.jsp")), "DoEndTagEvalPageTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/DoEndTagSkipPageTest.jsp")), "DoEndTagSkipPageTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/DoStartEvalBodyIncludeTest.jsp")), "DoStartEvalBodyIncludeTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/DoStartSkipBodyTest.jsp")), "DoStartSkipBodyTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/FindAncestorTest.jsp")), "FindAncestorTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/MethodValidation.jsp")), "MethodValidation.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/TagInitializationTest.jsp")), "TagInitializationTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/TagSupportApiTest.jsp")), "TagSupportApiTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/TagSupportSynchronizationTest.jsp")), "TagSupportSynchronizationTest.jsp");
        return archive;
    }

    @Test
    public void tagSupportTagInitializationTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagsupport_web/TagInitializationTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    public void tagSupportDoStartEvalBodyIncludeTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagsupport_web/DoStartEvalBodyIncludeTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        TEST_PROPS.setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
    }

    @Test
    public void tagSupportDoStartSkipBodyTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagsupport_web/DoStartSkipBodyTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        TEST_PROPS.setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
    }

    @Test
    public void tagSupportDoAfterBodySkipBodyTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagsupport_web/DoAfterBodySkipBodyTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Body Evaluated1|Test PASSED");
        TEST_PROPS.setProperty("unexpected_response_match", "Test FAILED|Body Evaluated2");
        this.invoke();
    }

    @Test
    public void tagSupportDoAfterBodyEvalBodyAgainTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagsupport_web/DoAfterBodyEvalBodyAgainTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        TEST_PROPS.setProperty("search_string", "Body Evaluated1|Body Evaluated2");
        TEST_PROPS.setProperty("unexpected_response_match", "Test FAILED|Body Evaluated3");
        this.invoke();
    }

    @Test
    public void tagSupportDoEndTagSkipPageTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagsupport_web/DoEndTagSkipPageTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_tagsupport_web/MethodValidation.jsp?name=interaction&methods=doStartTag,doEndTag HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_tagsupport_web/MethodValidation.jsp?name=parent&methods=doStartTag HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    public void tagSupportDoEndTagEvalPageTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagsupport_web/DoEndTagEvalPageTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED|Test PASSED1");
        TEST_PROPS.setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
    }

    @Test
    public void tagSupportFindAncestorWithClassTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagsupport_web/FindAncestorTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    public void tagSupportDoStartTagDefaultValueTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "doStartTagTest");
        this.invoke();
    }

    @Test
    public void tagSupportDoEndTagDefaultValueTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "doEndTagTest");
        this.invoke();
    }

    @Test
    public void tagSupportDoAfterBodyDefaultValueTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "doAfterBodyTest");
        this.invoke();
    }

    @Test
    public void tagSupportGetSetValueTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "setGetValue");
        this.invoke();
    }

    @Test
    public void tagSupportGetValuesTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "getValues");
        this.invoke();
    }

    @Test
    public void tagSupportRemoveValueTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "removeValue");
        this.invoke();
    }

    @Test
    public void tagSupportVariableSynchronizationTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagsupport_web/TagSupportSynchronizationTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
    }
}

