/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.common.client.handler;

import ee.jakarta.tck.pages.common.client.handler.Handler;
import ee.jakarta.tck.pages.common.client.handler.LocationHandler;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.apache.commons.httpclient.Header;

public class SetCookieHandler
implements Handler {
    private static final Logger LOGGER = Logger.getLogger(LocationHandler.class.getName());
    private static final Handler HANDLER = new SetCookieHandler();
    private static final String DELIM = "##";

    private SetCookieHandler() {
    }

    public static Handler getInstance() {
        return HANDLER;
    }

    @Override
    public boolean invoke(Header configuredHeader, Header responseHeader) {
        String setCookieHeader = responseHeader.getValue().toLowerCase();
        String expectedValues = configuredHeader.getValue().toLowerCase();
        LOGGER.finer("Set-Cookie header received: " + setCookieHeader);
        StringTokenizer conf = new StringTokenizer(expectedValues, DELIM);
        while (conf.hasMoreTokens()) {
            String token;
            String token1 = token = conf.nextToken();
            if (token.endsWith("\"") && token.indexOf("=\"") > 1) {
                token1 = token.replace("=\"", "=");
                token1 = token1.substring(0, token.length() - 2);
            }
            if (token.startsWith("!")) {
                String attr = token.substring(1);
                String attr1 = token1.substring(1);
                if (setCookieHeader.indexOf(attr) <= -1 && setCookieHeader.indexOf(attr1) <= -1) continue;
                LOGGER.severe("Unexpected attribute found  Set-Cookie header.  Attribute: " + attr + "\nSet-Cookie header: " + setCookieHeader);
                return false;
            }
            if (setCookieHeader.indexOf(token) < 0 && setCookieHeader.indexOf(token1) < 0) {
                LOGGER.severe("Unable to find '" + token + "' within the Set-Cookie header returned by the server.");
                return false;
            }
            LOGGER.severe("Found expected value, '" + token + "' in Set-Cookie header returned by server.");
        }
        return true;
    }
}

