/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.core_syntax.actions.text;

import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import ee.jakarta.tck.pages.common.util.JspTestUtil;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    public URLClientIT() throws Exception {
        this.setContextRoot("/jsp_core_act_text_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_core_act_text_web.war");
        archive.addClasses(new Class[]{JspTestUtil.class});
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_core_act_text_web.xml"));
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/JspTextTag.tag", "tags/JspTextTag.tag");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspTextBodyRestrictionsTest1.jsp")), "JspTextBodyRestrictionsTest1.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspTextBodyRestrictionsTest2.jsp")), "JspTextBodyRestrictionsTest2.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspTextBodyRestrictionsTest3.jsp")), "JspTextBodyRestrictionsTest3.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspTextBodyRestrictionsTest4.jsp")), "JspTextBodyRestrictionsTest4.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspTextBodyRestrictionsTest5.jspx")), "JspTextBodyRestrictionsTest5.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspTextUsageContextTest1.jsp")), "JspTextUsageContextTest1.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspTextUsageContextTest2.jspx")), "JspTextUsageContextTest2.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspTextUsageContextTest3.jsp")), "JspTextUsageContextTest3.jsp");
        return archive;
    }

    @Test
    public void jspTextUsageContextTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_text_web/JspTextUsageContextTest1.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Template\nText|Template Text2");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_text_web/JspTextUsageContextTest2.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Template\nText|Template Text2");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_text_web/JspTextUsageContextTest3.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Template Text|Template\nText2");
        this.invoke();
    }

    @Test
    public void jspTextBodyRestrictionsTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_text_web/JspTextBodyRestrictionsTest1.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_text_web/JspTextBodyRestrictionsTest2.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_text_web/JspTextBodyRestrictionsTest3.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_text_web/JspTextBodyRestrictionsTest4.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_text_web/JspTextBodyRestrictionsTest5.jspx HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }
}

