/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.el.jsp;

import ee.jakarta.tck.pages.common.util.JspTestUtil;
import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.SimpleTagSupport;
import java.io.IOException;

public class ELDeferredValueValueTag
extends SimpleTagSupport {
    private static final String LITVAL = "foo";
    private static final String POUNDVAL = "bar";
    private ValueExpression litExpr;
    private ValueExpression poundExpr;

    public void setLitExpr(ValueExpression litExpr) {
        this.litExpr = litExpr;
    }

    public void setPoundExpr(ValueExpression poundExpr) {
        this.poundExpr = poundExpr;
    }

    public void doTag() throws JspException, IOException {
        ELContext elContext = this.getJspContext().getELContext();
        JspWriter out = this.getJspContext().getOut();
        try {
            String litVal = (String)this.litExpr.getValue(elContext);
            if (!litVal.equals(LITVAL)) {
                out.println("Test FAILED. Wrong value for literal expression.");
                out.println("Expected value: foo");
                out.println("Retrieved value: " + litVal);
                return;
            }
            String poundVal = (String)this.poundExpr.getValue(elContext);
            if (!poundVal.equals(POUNDVAL)) {
                out.println("Test FAILED. Wrong value for pound expression.");
                out.println("Expected value: bar");
                out.println("Retrieved value: " + poundVal);
                return;
            }
            out.println("Test PASSED.");
        }
        catch (Throwable t) {
            JspTestUtil.handleThrowable(t, out, "ELDeferredValueValueTag");
        }
    }
}

