/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.tagfiles.semantics;

import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import ee.jakarta.tck.pages.common.util.JspTestUtil;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    public URLClientIT() throws Exception {
        this.setContextRoot("/jsp_tagfile_semantics_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_tagfile_semantics_web.war");
        archive.addClasses(new Class[]{JspTestUtil.class});
        archive.addPackages(true, Filters.exclude((Class[])new Class[]{URLClientIT.class}), new String[]{URLClientIT.class.getPackageName()});
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_tagfile_semantics_web.xml"));
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/AttributeNotSpecifiedTag.tag", "tags/AttributeNotSpecifiedTag.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/DeclaredAttributesTag.tag", "tags/DeclaredAttributesTag.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/DynamicAttributesTag.tag", "tags/DynamicAttributesTag.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/JspContextWrapperScopesTag.tag", "tags/JspContextWrapperScopesTag.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/JspContextWrapperTag.tag", "tags/JspContextWrapperTag.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/semanticsInvokeClassicTag.tag", "tags/semanticsInvokeClassicTag.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/semanticsInvokeSimpleTag.tag", "tags/semanticsInvokeSimpleTag.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/semanticsJspForward.tag", "tags/semanticsJspForward.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/mytags.tld", "mytags.tld");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspTagSemanticsAttributeNotSpecifiedTest.jsp")), "JspTagSemanticsAttributeNotSpecifiedTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspTagSemanticsDeclaredAttributesTest.jsp")), "JspTagSemanticsDeclaredAttributesTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspTagSemanticsDynamicAttributesTest.jsp")), "JspTagSemanticsDynamicAttributesTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspTagSemanticsJspContextWrapperTest.jsp")), "JspTagSemanticsJspContextWrapperTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspTagSemanticsScopesTest.jsp")), "JspTagSemanticsScopesTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/semanticsInvokeClassicTag.jsp")), "semanticsInvokeClassicTag.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/semanticsInvokeSimpleTag.jsp")), "semanticsInvokeSimpleTag.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/semanticsJspForward.jsp")), "semanticsJspForward.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/semanticsJspForwardTarget.jsp")), "semanticsJspForwardTarget.jsp");
        return archive;
    }

    @Test
    public void jspTagSemanticsJspContextWrapperTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_semantics_web/JspTagSemanticsJspContextWrapperTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        TEST_PROPS.setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
    }

    @Test
    public void jspTagSemanticsJspContextWrapperScopesTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_semantics_web/JspTagSemanticsScopesTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Wrapper Test PASSED|Test PASSED|Wrapper Test PASSED|Test PASSED");
        TEST_PROPS.setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
    }

    @Test
    public void jspTagSemanticsDeclaredAttributesTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_semantics_web/JspTagSemanticsDeclaredAttributesTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        TEST_PROPS.setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
    }

    @Test
    public void jspTagSemanticsAttributeNotSpecifiedTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_semantics_web/JspTagSemanticsAttributeNotSpecifiedTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        TEST_PROPS.setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
    }

    @Test
    public void jspTagSemanticsDynamicAttributesTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_semantics_web/JspTagSemanticsDynamicAttributesTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        TEST_PROPS.setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
    }

    @Test
    public void semanticsJspForwardTest() throws Exception {
        String testName = "semanticsJspForward";
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_semantics_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        TEST_PROPS.setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
    }

    @Test
    public void semanticsInvokeSimpleTagTest() throws Exception {
        String testName = "semanticsInvokeSimpleTag";
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_semantics_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        TEST_PROPS.setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
    }

    @Test
    public void semanticsInvokeClassicTagTest() throws Exception {
        String testName = "semanticsInvokeClassicTag";
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_semantics_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "MyClassicTag:Test PASSED|endOfTagFile|endOfCallingPage");
        this.invoke();
    }
}

