/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.core.variantlistbuilder;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Variant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 1L;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void newInstanceTest() throws JAXRSCommonClient.Fault {
        List vt = Variant.VariantListBuilder.newInstance().build();
        if (!vt.isEmpty()) {
            throw new JAXRSCommonClient.Fault("List<Variant> returned is not empty.  It includes " + vt.size() + " Variant.");
        }
    }

    @Test
    public void mediaTypesTest1() throws JAXRSCommonClient.Fault {
        boolean pass = true;
        StringBuffer sb = new StringBuffer();
        ArrayList<String> encoding = new ArrayList<String>();
        ArrayList<String> lang = new ArrayList<String>();
        MediaType mt1 = new MediaType();
        MediaType mt2 = new MediaType("application", "atom+xml");
        List<MediaType> types = Arrays.asList(mt1, mt2);
        List vts = Variant.VariantListBuilder.newInstance().mediaTypes(new MediaType[]{mt1, mt2}).add().build();
        String status = JAXRSClientIT.verifyVariants(vts, types, encoding, lang, 2);
        if (status.endsWith("false")) {
            pass = false;
        }
        sb.append(status);
        Assertions.assertTrue((boolean)pass, (String)("At least one assertion faled: " + sb.toString()));
        TestUtil.logTrace(sb.toString());
    }

    @Test
    public void mediaTypesTest2() throws JAXRSCommonClient.Fault {
        boolean pass = true;
        StringBuffer sb = new StringBuffer();
        ArrayList<String> encoding = new ArrayList<String>();
        ArrayList<String> lang = new ArrayList<String>();
        HashMap params = new HashMap();
        MediaType mt1 = new MediaType();
        MediaType mt2 = new MediaType("application", "atom+xml");
        MediaType mt3 = new MediaType("application", "x-www-form-urlencoded", params);
        List<MediaType> types = Arrays.asList(mt1, mt2, mt3);
        List vts = Variant.VariantListBuilder.newInstance().mediaTypes(new MediaType[]{mt1, mt2, mt3}).add().build();
        String status = JAXRSClientIT.verifyVariants(vts, types, encoding, lang, 3);
        if (status.endsWith("false")) {
            pass = false;
        }
        sb.append(status);
        Assertions.assertTrue((boolean)pass, (String)("At least one assertion faled: " + sb.toString()));
        TestUtil.logTrace(sb.toString());
    }

    @Test
    public void languageTest() throws JAXRSCommonClient.Fault {
        boolean pass = true;
        StringBuffer sb = new StringBuffer();
        ArrayList<String> encoding = new ArrayList<String>();
        MediaType mt1 = new MediaType();
        List<MediaType> types = Arrays.asList(mt1);
        List vts = Variant.VariantListBuilder.newInstance().mediaTypes(new MediaType[]{mt1}).languages(new Locale[]{new Locale("en", "US"), new Locale("en", "GB"), new Locale("zh", "CN")}).add().build();
        int size = vts.size();
        sb.append("size================== " + size + newline);
        String status = JAXRSClientIT.verifyVariants(vts, types, encoding, JAXRSClientIT.getLangList(), 3);
        if (status.endsWith("false")) {
            pass = false;
        }
        sb.append(status);
        Assertions.assertTrue((boolean)pass, (String)("At least one assertion faled: " + sb.toString()));
        TestUtil.logTrace(sb.toString());
    }

    @Test
    public void encodingTest() throws JAXRSCommonClient.Fault {
        boolean pass = true;
        StringBuffer sb = new StringBuffer();
        List<String> encoding = Arrays.asList("gzip", "compress");
        ArrayList<String> lang = new ArrayList<String>();
        MediaType mt1 = new MediaType();
        List<MediaType> types = Arrays.asList(mt1);
        List vts = Variant.VariantListBuilder.newInstance().mediaTypes(new MediaType[]{mt1}).encodings(new String[]{"gzip", "compress"}).add().build();
        String status = JAXRSClientIT.verifyVariants(vts, types, encoding, lang, 2);
        if (status.endsWith("false")) {
            pass = false;
        }
        sb.append(status);
        TestUtil.logTrace(sb.toString());
        Assertions.assertTrue((boolean)pass, (String)("At least one assertion faled: " + sb.toString()));
    }

    @Test
    public void complexTest() throws JAXRSCommonClient.Fault {
        boolean pass = true;
        StringBuffer sb = new StringBuffer();
        List<String> encoding = Arrays.asList("gzip", "compress");
        MediaType mt1 = new MediaType();
        MediaType mt2 = new MediaType("application", "atom+xml");
        List<MediaType> types = Arrays.asList(mt1, mt2);
        List<Variant> vts = JAXRSClientIT.getVariantList(encoding, mt1, mt2);
        String status = JAXRSClientIT.verifyVariants(vts, types, encoding, JAXRSClientIT.getLangList(), 12);
        if (status.endsWith("false")) {
            pass = false;
        }
        sb.append(status);
        TestUtil.logTrace(sb.toString());
        Assertions.assertTrue((boolean)pass, (String)("At least one assertion faled: " + sb.toString()));
    }

    private static String verifyVariants(List<Variant> vts, List<MediaType> types, List<String> encoding, List<String> lang, int size_expected) {
        StringBuffer sb = new StringBuffer();
        boolean pass = true;
        ArrayList<MediaType> actual_types = new ArrayList<MediaType>();
        sb.append(newline + "========== Verifying Variants" + newline);
        int size_vt = vts.size();
        if (size_vt != size_expected) {
            sb.append("    Test Failed: List<Variant> returned is not right.  It includes " + size_vt + " Variant Objects. Expecting " + size_expected + newline);
            pass = false;
            for (int j = 0; j < vts.size(); ++j) {
                Variant vt = vts.get(j);
                sb.append("    Variant " + j + ": MediaType: " + vt.getMediaType().toString() + "; Langauge: " + vt.getLanguage() + "; Encoding: " + vt.getEncoding() + newline);
            }
        } else {
            sb.append("    Correct number of Variant returned: " + size_expected + newline);
        }
        for (Variant vt : vts) {
            sb.append("    ===== Verifying Variant" + newline);
            MediaType mt = vt.getMediaType();
            if (!types.contains(mt)) {
                pass = false;
                sb.append("    Unexpected MediaType found in variant: type=" + mt.getType() + " subtype = " + mt.getSubtype() + newline);
                sb.append("    Expecting the following MediaType:" + newline);
                for (MediaType mediaType : types) {
                    sb.append("        " + mediaType.getType() + "/" + mediaType.getSubtype() + newline);
                }
            } else {
                sb.append("    Expected MediaType found Variant: " + mt.getType() + " subtype = " + mt.getSubtype() + newline);
                actual_types.add(mt);
            }
            if (encoding == null || encoding.isEmpty()) {
                if (vt.getEncoding() == null) continue;
                pass = false;
                sb.append("    Unexpected encoding found: " + vt.getEncoding().toString());
                continue;
            }
            if (vt.getEncoding() == null) {
                pass = false;
                sb.append("    No encoding found: " + vt.getEncoding() + newline);
                sb.append("    Expecting the following encodings: " + newline);
                for (String string : encoding) {
                    sb.append("        " + string + newline);
                }
            } else if (!encoding.contains(vt.getEncoding().toString().toLowerCase())) {
                sb.append("    Unexpected encoding found: " + vt.getEncoding() + newline);
                sb.append("    Expecting the following encodings: " + newline);
                for (String string : lang) {
                    sb.append("        " + string + newline);
                }
                pass = false;
            } else {
                sb.append("    Found expected encoding " + vt.getEncoding() + newline);
            }
            if (lang == null || lang.isEmpty()) {
                if (vt.getLanguage() == null) continue;
                pass = false;
                sb.append("    Unexpected language found: " + vt.getLanguage().toString());
                continue;
            }
            if (vt.getLanguage() == null) {
                pass = false;
                sb.append("    No language found: " + vt.getLanguage() + newline);
                sb.append("    Expecting the following languages: " + newline);
                for (String string : lang) {
                    sb.append("        " + string + newline);
                }
                continue;
            }
            if (!lang.contains(JAXRSClientIT.langToString(vt.getLanguage()))) {
                sb.append("    Unexpected language found: " + vt.getLanguage() + newline);
                sb.append("    Expecting the following languages: " + newline);
                for (String string : lang) {
                    sb.append("        " + string + newline);
                }
                pass = false;
                continue;
            }
            sb.append("    Found expected language " + vt.getLanguage() + newline);
        }
        LinkedHashSet<MediaType> set = new LinkedHashSet<MediaType>();
        set.addAll(actual_types);
        ArrayList final_types = new ArrayList(set);
        if (types.size() != final_types.size()) {
            pass = false;
            sb.append("Some missing MediaType: expecting " + types.size() + ", only got " + final_types.size() + newline);
            for (int i = 0; i < final_types.size(); ++i) {
                sb.append(((MediaType)final_types.get(i)).toString() + newline);
            }
        }
        sb.append(pass);
        return sb.toString();
    }

    protected static List<String> getLangList() {
        return Arrays.asList("en-US", "en-GB", "zh-CN");
    }

    protected static List<Variant> getVariantList(List<String> encoding, MediaType ... mt) {
        return Variant.VariantListBuilder.newInstance().mediaTypes(mt).languages(new Locale[]{new Locale("en", "US"), new Locale("en", "GB"), new Locale("zh", "CN")}).encodings(encoding.toArray(new String[0])).add().build();
    }

    protected static String langToString(Object object) {
        Locale locale = null;
        if (object instanceof List) {
            object = ((List)object).iterator().next();
        }
        if (object instanceof Locale) {
            locale = (Locale)object;
        }
        return locale == null ? object.toString() : locale.toString().replace("_", "-");
    }
}

