/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.clienterrorexception;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 6441920735149224053L;
    protected static final String MESSAGE = "TCK ClientErrorException description";
    protected static final String HOST = "www.jcp.org";

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void constructorStatusTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (Response.Status.Family.familyOf((int)status.getStatusCode()) != Response.Status.Family.CLIENT_ERROR) continue;
            ClientErrorException e = new ClientErrorException(status);
            this.assertResponse(e, status);
        }
    }

    @Test
    public void constructorStatusThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (Response.Status.Family.familyOf((int)status.getStatusCode()) == Response.Status.Family.CLIENT_ERROR) continue;
            try {
                ClientErrorException e = new ClientErrorException(status);
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStatusNullThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        try {
            ClientErrorException e = new ClientErrorException((Response.Status)null);
            JAXRSClientIT.fault("IllegalArgumentException has not been thrown for null status; exception", e);
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for null status");
        }
    }

    @Test
    public void constructorIntTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (Response.Status.Family.familyOf((int)status.getStatusCode()) != Response.Status.Family.CLIENT_ERROR) continue;
            ClientErrorException e = new ClientErrorException(status.getStatusCode());
            this.assertResponse(e, status);
        }
    }

    @Test
    public void constructorIntThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (Response.Status.Family.familyOf((int)status.getStatusCode()) == Response.Status.Family.CLIENT_ERROR) continue;
            try {
                ClientErrorException e = new ClientErrorException(status.getStatusCode());
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorIntNotValidStatusThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (int status : new int[]{-1, 999, Integer.MIN_VALUE, Integer.MAX_VALUE}) {
            try {
                ClientErrorException e = new ClientErrorException(status);
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorResponseTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (Response.Status.Family.familyOf((int)status.getStatusCode()) != Response.Status.Family.CLIENT_ERROR) continue;
            Response response = this.buildResponse(status);
            ClientErrorException e = new ClientErrorException(response);
            this.assertResponse(e, status, HOST);
        }
    }

    @Test
    public void constructorResponseThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (Response.Status.Family.familyOf((int)status.getStatusCode()) == Response.Status.Family.CLIENT_ERROR) continue;
            try {
                Response response = Response.status((Response.Status)status).build();
                ClientErrorException e = new ClientErrorException(response);
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStatusThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()};
        for (Response.Status status : Response.Status.values()) {
            if (Response.Status.Family.familyOf((int)status.getStatusCode()) != Response.Status.Family.CLIENT_ERROR) continue;
            for (Throwable throwable : throwables) {
                ClientErrorException e = new ClientErrorException(status, throwable);
                this.assertResponse(e, status);
                this.assertCause((WebApplicationException)e, throwable);
            }
        }
    }

    @Test
    public void constructorStatusThrowableThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (Response.Status.Family.familyOf((int)status.getStatusCode()) == Response.Status.Family.CLIENT_ERROR) continue;
            try {
                ClientErrorException e = new ClientErrorException(status, new Throwable());
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStatusNullThrowableThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        try {
            ClientErrorException e = new ClientErrorException((Response.Status)null, new Throwable());
            JAXRSClientIT.fault("IllegalArgumentException has not been thrown for null status; exception", e);
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for null status");
        }
    }

    @Test
    public void constructorIntThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()};
        for (Response.Status status : Response.Status.values()) {
            if (Response.Status.Family.familyOf((int)status.getStatusCode()) != Response.Status.Family.CLIENT_ERROR) continue;
            for (Throwable throwable : throwables) {
                ClientErrorException e = new ClientErrorException(status.getStatusCode(), throwable);
                this.assertResponse(e, status);
                this.assertCause((WebApplicationException)e, throwable);
            }
        }
    }

    @Test
    public void constructorIntThrowableThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (Response.Status.Family.familyOf((int)status.getStatusCode()) == Response.Status.Family.CLIENT_ERROR) continue;
            try {
                ClientErrorException e = new ClientErrorException(status.getStatusCode(), new Throwable());
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorIntNotValidStatusThrowableThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (int status : new int[]{-1, 999, Integer.MIN_VALUE, Integer.MAX_VALUE}) {
            try {
                ClientErrorException e = new ClientErrorException(status, new Throwable());
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorResponseThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()};
        for (Response.Status status : Response.Status.values()) {
            if (Response.Status.Family.familyOf((int)status.getStatusCode()) != Response.Status.Family.CLIENT_ERROR) continue;
            for (Throwable throwable : throwables) {
                Response response = this.buildResponse(status);
                ClientErrorException e = new ClientErrorException(response, throwable);
                this.assertResponse(e, status, HOST);
                this.assertCause((WebApplicationException)e, throwable);
            }
        }
    }

    @Test
    public void constructorResponseThrowableThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (Response.Status.Family.familyOf((int)status.getStatusCode()) == Response.Status.Family.CLIENT_ERROR) continue;
            try {
                Response response = Response.status((Response.Status)status).build();
                ClientErrorException e = new ClientErrorException(response, new Throwable());
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStringStatusTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (Response.Status.Family.familyOf((int)status.getStatusCode()) != Response.Status.Family.CLIENT_ERROR) continue;
            ClientErrorException e = new ClientErrorException(MESSAGE, status);
            this.assertResponse(e, status);
            this.assertMessage(e);
        }
    }

    @Test
    public void constructorStringStatusThrowsIAETest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (Response.Status.Family.familyOf((int)status.getStatusCode()) == Response.Status.Family.CLIENT_ERROR) continue;
            try {
                ClientErrorException e = new ClientErrorException(MESSAGE, status);
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStringStatusNullThrowsIAETest() throws JAXRSCommonClient.Fault {
        try {
            ClientErrorException e = new ClientErrorException(MESSAGE, (Response.Status)null);
            JAXRSClientIT.fault("IllegalArgumentException has not been thrown for null status; exception", e);
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for null status");
        }
    }

    @Test
    public void constructorStringIntTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (Response.Status.Family.familyOf((int)status.getStatusCode()) != Response.Status.Family.CLIENT_ERROR) continue;
            ClientErrorException e = new ClientErrorException(MESSAGE, status.getStatusCode());
            this.assertResponse(e, status);
            this.assertMessage(e);
        }
    }

    @Test
    public void constructorStringIntThrowsIAETest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (Response.Status.Family.familyOf((int)status.getStatusCode()) == Response.Status.Family.CLIENT_ERROR) continue;
            try {
                ClientErrorException e = new ClientErrorException(MESSAGE, status.getStatusCode());
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStringIntNotValidStatusThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (int status : new int[]{-1, 999, Integer.MIN_VALUE, Integer.MAX_VALUE}) {
            try {
                ClientErrorException e = new ClientErrorException(MESSAGE, status);
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStringResponseTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (Response.Status.Family.familyOf((int)status.getStatusCode()) != Response.Status.Family.CLIENT_ERROR) continue;
            Response response = this.buildResponse(status);
            ClientErrorException e = new ClientErrorException(MESSAGE, response);
            this.assertResponse(e, status, HOST);
            this.assertMessage(e);
        }
    }

    @Test
    public void constructorStringResponseThrowsIEATest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (Response.Status.Family.familyOf((int)status.getStatusCode()) == Response.Status.Family.CLIENT_ERROR) continue;
            try {
                Response response = Response.status((Response.Status)status).build();
                ClientErrorException e = new ClientErrorException(MESSAGE, response);
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStringStatusThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()};
        for (Response.Status status : Response.Status.values()) {
            if (Response.Status.Family.familyOf((int)status.getStatusCode()) != Response.Status.Family.CLIENT_ERROR) continue;
            for (Throwable throwable : throwables) {
                ClientErrorException e = new ClientErrorException(MESSAGE, status, throwable);
                this.assertResponse(e, status);
                this.assertCause((WebApplicationException)e, throwable);
                this.assertMessage(e);
            }
        }
    }

    @Test
    public void constructorStringStatusThrowableThrowsIAETest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (Response.Status.Family.familyOf((int)status.getStatusCode()) == Response.Status.Family.CLIENT_ERROR) continue;
            try {
                ClientErrorException e = new ClientErrorException(MESSAGE, status, new Throwable());
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStringStatusNullThrowableThrowsIAETest() throws JAXRSCommonClient.Fault {
        try {
            ClientErrorException e = new ClientErrorException(MESSAGE, (Response.Status)null, new Throwable());
            JAXRSClientIT.fault("IllegalArgumentException has not been thrown for null status; exception", e);
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for null status");
        }
    }

    @Test
    public void constructorStringIntThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()};
        for (Response.Status status : Response.Status.values()) {
            if (Response.Status.Family.familyOf((int)status.getStatusCode()) != Response.Status.Family.CLIENT_ERROR) continue;
            for (Throwable throwable : throwables) {
                ClientErrorException e = new ClientErrorException(MESSAGE, status.getStatusCode(), throwable);
                this.assertResponse(e, status);
                this.assertCause((WebApplicationException)e, throwable);
                this.assertMessage(e);
            }
        }
    }

    @Test
    public void constructorStringIntThrowableThrowsIAETest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (Response.Status.Family.familyOf((int)status.getStatusCode()) == Response.Status.Family.CLIENT_ERROR) continue;
            try {
                ClientErrorException e = new ClientErrorException(MESSAGE, status.getStatusCode(), new Throwable());
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStringIntNotValidStatusThrowableThrowsIAETest() throws JAXRSCommonClient.Fault {
        for (int status : new int[]{-1, 999, Integer.MIN_VALUE, Integer.MAX_VALUE}) {
            try {
                ClientErrorException e = new ClientErrorException(MESSAGE, status, new Throwable());
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStringResponseThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()};
        for (Response.Status status : Response.Status.values()) {
            if (Response.Status.Family.familyOf((int)status.getStatusCode()) != Response.Status.Family.CLIENT_ERROR) continue;
            for (Throwable throwable : throwables) {
                Response response = this.buildResponse(status);
                ClientErrorException e = new ClientErrorException(MESSAGE, response, throwable);
                this.assertResponse(e, status, HOST);
                this.assertCause((WebApplicationException)e, throwable);
                this.assertMessage(e);
            }
        }
    }

    @Test
    public void constructorStringResponseThrowableThrowsIAETest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (Response.Status.Family.familyOf((int)status.getStatusCode()) == Response.Status.Family.CLIENT_ERROR) continue;
            try {
                Response response = Response.status((Response.Status)status).build();
                ClientErrorException e = new ClientErrorException(MESSAGE, response, new Throwable());
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    protected Response buildResponse(Response.Status status) {
        Response r = Response.status((Response.Status)status).header("Host", (Object)HOST).build();
        return r;
    }

    protected void assertResponse(ClientErrorException e, Response.Status status) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertNotNull(e.getResponse(), "getResponse is null");
        int got = e.getResponse().getStatus();
        JAXRSClientIT.assertEqualsInt(got, status.getStatusCode(), "Status set in Response", got, "differes from expected", status);
        JAXRSClientIT.logMsg("Response of the exception contains expected status", status);
    }

    protected void assertResponse(ClientErrorException e, Response.Status status, String host) throws JAXRSCommonClient.Fault {
        this.assertResponse(e, status);
        String header = e.getResponse().getHeaderString("Host");
        JAXRSClientIT.assertNotNull(header, "http header", "Host", " of response is null");
        JAXRSClientIT.assertEquals(host, header, "Found unexpected http", "Host", "header", header);
        JAXRSClientIT.logMsg("Found expected http", "Host", "header");
    }

    protected void assertCause(WebApplicationException e, Throwable expected) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertEquals(e.getCause(), expected, "#getCause does not contain expected", expected, "but", e.getCause());
        JAXRSClientIT.logMsg("getCause contains expected", expected);
    }

    protected void assertMessage(ClientErrorException e) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertNotNull(e.getMessage(), "getMessage() is null");
        JAXRSClientIT.assertContains(e.getMessage(), MESSAGE, new Object[]{"Unexpected getMessage()", e.getMessage()});
        JAXRSClientIT.logMsg("found expected getMessage()=", e.getMessage());
    }
}

