/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.api.jakarta_servlet_http.cookie;

import java.net.HttpCookie;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.TimeZone;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import servlet.tck.api.jakarta_servlet_http.cookie.TestServlet;
import servlet.tck.common.client.AbstractTckTest;
import servlet.tck.common.request.HttpExchange;
import servlet.tck.common.request.HttpResponse;
import servlet.tck.common.servlets.CommonServlets;

public class CookieTests
extends AbstractTckTest {
    @BeforeEach
    public void setupServletName() throws Exception {
        this.setServletName("TestServlet");
    }

    @Deployment(testable=false)
    public static WebArchive getTestArchive() throws Exception {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"servlet_jsh_cookie_web.war")).addAsLibraries((Archive[])CommonServlets.getCommonServletsArchive())).addClasses(new Class[]{TestServlet.class})).setWebXML(CookieTests.class.getResource("servlet_jsh_cookie_web.xml"));
    }

    @Test
    public void cloneTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "cloneTest");
        this.invoke();
    }

    @Test
    public void constructorTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "constructorTest");
        this.invoke();
    }

    @Test
    public void constructorIllegalArgumentExceptionTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET /servlet_jsh_cookie_web/TestServlet?testname=constructorIllegalArgumentExceptionTest HTTP/1.1");
        ((Properties)TEST_PROPS.get()).setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
    }

    @Test
    public void getCommentTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getCommentTest");
        this.invoke();
    }

    @Test
    public void getCommentNullTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getCommentNullTest");
        this.invoke();
    }

    @Test
    public void getDomainTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getDomainTest");
        this.invoke();
    }

    @Test
    public void getMaxAgeTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getMaxAgeTest");
        this.invoke();
    }

    @Test
    public void getNameTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("request_headers", "Cookie: name1=value1; Domain=" + this._hostname + "; Path=/servlet_jsh_cookie_web");
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getNameTest");
        this.invoke();
    }

    @Test
    public void getPathTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getPathTest");
        this.invoke();
    }

    @Test
    public void getSecureTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getSecureTest");
        this.invoke();
    }

    @Test
    public void getAttributeSecureTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getAttributeSecureTest");
        this.invoke();
    }

    @Test
    public void getValueTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("request_headers", "Cookie: name1=value1; Domain=" + this._hostname + "; Path=/servlet_jsh_cookie_web");
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getValueTest");
        this.invoke();
    }

    @Test
    public void getValueQuotedTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("request_headers", "Cookie: name1=\"value1\"; Domain=" + this._hostname + "; Path=/servlet_jsh_cookie_web");
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getValueQuotedTest");
        this.invoke();
    }

    @Test
    public void getVersionTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getVersionTest");
        this.invoke();
    }

    @Test
    public void setDomainTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "setDomainTest");
        this.invoke();
    }

    @Test
    public void setMaxAgePositiveTest() throws Exception {
        String testName = "setMaxAgePositiveTest";
        HttpResponse response = null;
        String dateHeader = null;
        Date expiryDate = null;
        String body = null;
        HttpExchange request = new HttpExchange("GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testName + " HTTP/1.1", this._hostname, this._port);
        try {
            response = request.execute();
            dateHeader = response.getResponseHeader("testDate").orElseThrow(() -> new NullPointerException("testDate is empty")).getValue();
            this.logger.trace("Found {} set-cookie entry", (Object)String.valueOf(response.getResponseHeaders("Set-Cookie").size()));
            boolean foundcookie = false;
            List<String> cookiesHeaders = response.getResponseHeaders("Set-Cookie");
            for (int i = 0; i < cookiesHeaders.size(); ++i) {
                List<HttpCookie> cookies;
                Optional<HttpCookie> optionalHttpCookie;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Checking set-cookiei {}:{}", (Object)String.valueOf(i), (Object)cookiesHeaders.get(i));
                }
                if (!(optionalHttpCookie = (cookies = HttpCookie.parse(cookiesHeaders.get(i))).stream().filter(httpCookie -> httpCookie.getName().equals("name1")).findFirst()).isPresent()) continue;
                HttpCookie httpCookie2 = optionalHttpCookie.get();
                expiryDate = new Date(httpCookie2.getMaxAge());
                body = response.getResponseBodyAsString();
                foundcookie = true;
                break;
            }
            if (!foundcookie) {
                throw new Exception("The test cookie was not located in the response");
            }
        }
        catch (Throwable t) {
            throw new Exception("Exception occurred:" + t, t);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(TestServlet.CUSTOM_HEADER_DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        String resultStringDate = sdf.format(expiryDate);
        try {
            Date resultDate = sdf.parse(resultStringDate);
            Date expectedDate = sdf.parse(dateHeader.substring(dateHeader.indexOf(": ") + 2).trim());
            if (resultDate.before(expectedDate)) {
                throw new Exception("The expiry date was incorrect, expected =" + expectedDate + ", result = " + resultDate);
            }
        }
        catch (Throwable t) {
            throw new Exception("Exception occurred: " + t);
        }
        if (body == null || !body.contains("Test PASSED")) {
            throw new Exception("The string: Test PASSED not found in response");
        }
    }

    @Test
    public void setMaxAgeZeroTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "setMaxAgeZeroTest");
        ((Properties)TEST_PROPS.get()).setProperty("expected_headers", "Set-Cookie:name1=value1##!Max-Age##Expires=");
        this.invoke();
    }

    @Test
    public void setMaxAgeZeroDateTest() throws Exception {
        String testName = "setMaxAgeZeroTest";
        HttpResponse response = null;
        Date expiryDate = null;
        String body = null;
        HttpExchange request = new HttpExchange("GET " + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testName + " HTTP/1.1", this._hostname, this._port);
        try {
            response = request.execute();
            this.logger.trace("Found {} set-cookie entry", (Object)String.valueOf(response.getResponseHeaders("Set-Cookie").size()));
            boolean foundcookie = false;
            List<String> cookiesHeaders = response.getResponseHeaders("Set-Cookie");
            for (int i = 0; i < cookiesHeaders.size(); ++i) {
                this.logger.trace("Checking set-cookie i {}:{}", (Object)String.valueOf(i), (Object)cookiesHeaders.get(i));
                List<HttpCookie> cookies = HttpCookie.parse(cookiesHeaders.get(i));
                Optional<HttpCookie> optionalHttpCookie = cookies.stream().filter(httpCookie -> httpCookie.getName().equals("name1")).findFirst();
                if (!optionalHttpCookie.isPresent()) continue;
                HttpCookie httpCookie2 = optionalHttpCookie.get();
                expiryDate = new Date(httpCookie2.getMaxAge());
                body = response.getResponseBodyAsString();
                foundcookie = true;
                break;
            }
            if (!foundcookie) {
                throw new Exception("The test cookie was not located in the response");
            }
        }
        catch (Throwable t) {
            throw new Exception("Exception occurred:" + t, t);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(TestServlet.CUSTOM_HEADER_DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        String resultStringDate = sdf.format(expiryDate);
        try {
            Date resultDate = sdf.parse(resultStringDate);
            Date expectedDate = new Date(System.currentTimeMillis());
            if (resultDate.after(expectedDate)) {
                throw new Exception("The expiry date was incorrect, expected =" + expectedDate + ", result = " + resultDate);
            }
        }
        catch (Throwable t) {
            throw new Exception("Exception occurred: " + t);
        }
        if (body == null || !body.contains("Test PASSED")) {
            throw new Exception("The string: Test PASSED not found in response");
        }
    }

    @Test
    public void setMaxAgeNegativeTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "setMaxAgeNegativeTest");
        ((Properties)TEST_PROPS.get()).setProperty("expected_headers", "Set-Cookie:name1=value1##!Expire##!Max-Age");
        this.invoke();
    }

    @Test
    public void setPathTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "setPathTest");
        ((Properties)TEST_PROPS.get()).setProperty("expected_headers", "Set-Cookie:Path=\"/servlet_jsh_cookie_web\"");
        this.invoke();
    }

    @Test
    public void setSecureTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "setSecureTest");
        this.invoke();
    }

    @Test
    public void setAttributeSecureTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "setAttributeSecureTest");
        this.invoke();
    }

    @Test
    public void setAttributeSecureInvalidTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "setAttributeSecureInvalidTest");
        this.invoke();
    }

    @Test
    public void setValueTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "setValueTest");
        this.invoke();
    }

    @Test
    public void setVersionTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "setVersionVer0Test");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "setVersionVer1Test");
        this.invoke();
    }

    @Test
    public void setAttributeTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "setAttributeTest");
        this.invoke();
    }

    @Test
    public void getAttributesTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getAttributesTest");
        this.invoke();
    }

    @Test
    public void getHttpOnlyTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getHttpOnlyTest");
        this.invoke();
    }

    @Test
    public void getAttributeHttpOnlyTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getAttributeHttpOnlyTest");
        this.invoke();
    }

    @Test
    public void setHttpOnlyTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "setHttpOnlyTest");
        this.invoke();
    }

    @Test
    public void setAttributeHttpOnlyTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "setAttributeHttpOnlyTest");
        this.invoke();
    }

    @Test
    public void setAttributeHttpOnlyInvalidTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "setAttributeHttpOnlyInvalidTest");
        this.invoke();
    }

    @Test
    public void setPartitionedTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "setPartitionedTest");
        ((Properties)TEST_PROPS.get()).setProperty("expected_headers", "Set-Cookie:name1=value1##Partitioned##!Partitioned=");
        this.invoke();
    }
}

