/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.spec.requestdispatcher;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import servlet.tck.common.servlets.HttpTCKServlet;

public class TestServlet
extends HttpTCKServlet {
    public void includeAttributes(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "/include/IncludedServlet?testname=attributes";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            rd.include((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void includeAttributes1(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "include/IncludedServlet?testname=attributes";
        RequestDispatcher rd = request.getRequestDispatcher(path);
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            rd.include((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void includeAttributes2(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "IncludedServlet";
        RequestDispatcher rd = this.getServletContext().getNamedDispatcher(path);
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            request.setAttribute("TestName", (Object)"attributes");
            rd.include((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void includeIOAndServletException(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        HashMap<String, String> testMap = new HashMap<String, String>();
        testMap.put("IOException", "include/IncludedServlet?testname=thrownIOException");
        testMap.put("ServletException", "include/IncludedServlet?testname=thrownServletException");
        testMap.keySet().iterator();
        for (String type : testMap.keySet()) {
            String path = (String)testMap.get(type);
            RequestDispatcher rd = request.getRequestDispatcher(path);
            if (rd == null) {
                pw.println("Null RequestDispatcher got for path=" + path);
                continue;
            }
            try {
                rd.include((ServletRequest)request, (ServletResponse)response);
                pw.println("Test FAILED with no propagation of " + type + " from IncludedServlet to TestServlet.");
            }
            catch (Throwable t) {
                Throwable targetThrowable = ((ServletException)t).getRootCause();
                if (type.equals("IOException")) {
                    if (targetThrowable instanceof IOException) {
                        pw.println("Test PASSED with proper propagation of " + type + " from IncludedServlet to TestServlet:" + targetThrowable.getMessage());
                    } else {
                        pw.println("Test FAILED with propagation of " + type + " from IncludedServlet to TestServlet - wrong type of Exception caught by TestServlet: " + targetThrowable.getClass().getName());
                    }
                }
                if (!type.equals("ServletException")) continue;
                if (targetThrowable instanceof ServletException) {
                    ServletException se = (ServletException)targetThrowable;
                    if (se.getRootCause() == null) {
                        pw.println("Test PASSED with proper propagation of " + type + " from IncludedServlet to TestServlet:" + targetThrowable.getMessage());
                        continue;
                    }
                    pw.println("Test FAILED.  ServletException thrown during RD operation resulted in that exception being wrapped by a ServletException.  ServletExceptions must be propagated as is to the caller.");
                    continue;
                }
                pw.println("Test FAILED with propagation of " + type + " from IncludedServlet to TestServlet - wrong type of Exception caught by TestServlet: " + targetThrowable.getClass().getName());
            }
        }
    }

    public void includeUnCheckedException(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "include/IncludedServlet?testname=thrownUnCheckedException";
        RequestDispatcher rd = request.getRequestDispatcher(path);
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            try {
                rd.include((ServletRequest)request, (ServletResponse)response);
                pw.println("Test FAILED with no propagation of RuntimeException from IncludedServlet to TestServlet.");
            }
            catch (Throwable t) {
                Throwable targetThrowable = ((ServletException)t).getRootCause();
                if (targetThrowable instanceof RuntimeException) {
                    pw.println("Test PASSED.  RuntimeException properly propagated.");
                }
                pw.println("Test FAILED with incorrect propagation of RuntimeException Exception from IncludedServlet to TestServlet - wrong type of Exception caught by TestServlet: " + t.getClass().getName());
            }
        }
    }

    public void includeCheckedException(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "include/IncludedServlet?testname=thrownCheckedException";
        RequestDispatcher rd = request.getRequestDispatcher(path);
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            try {
                rd.include((ServletRequest)request, (ServletResponse)response);
                pw.println("Test FAILED with no propagation of Exception from IncludedServlet to TestServlet.");
            }
            catch (ServletException se) {
                if (se.getRootCause() instanceof ClassNotFoundException) {
                    pw.println("Test PASSED with proper propagation of ClassNotFoundException from IncludedServlet to TestServlet.");
                }
            }
            catch (Throwable t) {
                pw.println("Test FAILED with incorrect propagation of RuntimeException Exception from IncludedServlet to TestServlet - wrong type of Exception caught by TestServlet: " + t.getClass().getName());
            }
        }
    }

    public void forwardAttributes(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "/forward/ForwardedServlet?testname=attributes&query=forwardAttributes";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void forwardAttributes1(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "/forward/ForwardedServlet?testname=attributes&query=forwardAttributes1";
        RequestDispatcher rd = request.getRequestDispatcher(path);
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void forwardAttributes2(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "ForwardedServlet";
        RequestDispatcher rd = this.getServletContext().getNamedDispatcher(path);
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            request.setAttribute("TestName", (Object)"attributes");
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void forwardAttributes6(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "/forward/MultiForwardedServlet?testname=attributes&query=forwardAttributes";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            request.setAttribute("TestName", (Object)"attributes");
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void forwardIOAndServletException(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        HashMap<String, String> testMap = new HashMap<String, String>();
        testMap.put("IOException", "forward/ForwardedServlet?testname=thrownIOException");
        testMap.put("ServletException", "forward/ForwardedServlet?testname=thrownServletException");
        testMap.keySet().iterator();
        for (String type : testMap.keySet()) {
            String path = (String)testMap.get(type);
            RequestDispatcher rd = request.getRequestDispatcher(path);
            if (rd == null) {
                pw.println("Null RequestDispatcher got for path=" + path);
                continue;
            }
            try {
                rd.include((ServletRequest)request, (ServletResponse)response);
                pw.println("Test FAILED with no propagation of " + type + " from ForwardedServlet to TestServlet.");
            }
            catch (Throwable t) {
                Throwable targetThrowable = ((ServletException)t).getRootCause();
                if (type.equals("IOException")) {
                    if (targetThrowable instanceof IOException) {
                        pw.println("Test PASSED with proper propagation of " + type + " from IncludedServlet to TestServlet:" + targetThrowable.getMessage());
                    } else {
                        pw.println("Test FAILED with propagation of " + type + " from IncludedServlet to TestServlet - wrong type of Exception caught by TestServlet: " + targetThrowable.getClass().getName());
                    }
                }
                if (!type.equals("ServletException")) continue;
                if (targetThrowable instanceof ServletException) {
                    ServletException se = (ServletException)targetThrowable;
                    if (se.getRootCause() == null) {
                        pw.println("Test PASSED with proper propagation of " + type + " from IncludedServlet to TestServlet:" + targetThrowable.getMessage());
                        continue;
                    }
                    pw.println("Test FAILED.  ServletException thrown during RD operation resulted in that exception being wrapped by a ServletException.  ServletExceptions must be propagated as is to the caller.");
                    continue;
                }
                pw.println("Test FAILED with propagation of " + type + " from IncludedServlet to TestServlet - wrong type of Exception caught by TestServlet: " + targetThrowable.getClass().getName());
            }
        }
    }

    public void forwardUnCheckedException(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "forward/ForwardedServlet?testname=thrownUnCheckedException";
        RequestDispatcher rd = request.getRequestDispatcher(path);
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            try {
                rd.include((ServletRequest)request, (ServletResponse)response);
                pw.println("Test FAILED with no propagation of RuntimeException from ForwardedServlet to TestServlet.");
            }
            catch (Throwable t) {
                Throwable targetThrowable = ((ServletException)t).getRootCause();
                if (targetThrowable instanceof RuntimeException) {
                    pw.println("Test PASSED.  RuntimeException properly propagated.");
                }
                pw.println("Test FAILED with incorrect propagation of RuntimeException Exception from IncludedServlet to TestServlet - wrong type of Exception caught by TestServlet: " + t.getClass().getName());
            }
        }
    }

    public void forwardCheckedException(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "forward/ForwardedServlet?testname=thrownCheckedException";
        RequestDispatcher rd = request.getRequestDispatcher(path);
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            try {
                rd.include((ServletRequest)request, (ServletResponse)response);
                pw.println("Test FAILED with no propagation of Exception from ForwardedServlet to TestServlet.");
            }
            catch (ServletException se) {
                if (se.getRootCause() instanceof ClassNotFoundException) {
                    pw.println("Test PASSED with proper propagation of ClassNotFoundException from ForwardServlet to TestServlet.");
                }
            }
            catch (Throwable t) {
                pw.println("Test FAILED with incorrect propagation of RuntimeException Exception from ForwardedServlet to TestServlet - wrong type of Exception caught by TestServlet: " + t.getClass().getName());
            }
        }
    }

    public void bufferContent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "/forward/ForwardedServlet?testname=bufferContent";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        pw.println("Test FAILED if you see this message");
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void getRequestURIIncludeTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "/other/HttpTestServlet?testname=getRequestURIIncludeTest";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            rd.include((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void getRequestURIForwardTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "/other/HttpTestServlet?testname=getRequestURIForwardTest";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void getRequestURIMultiForwardTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "/other/HttpTestServlet?testname=getRequestURIMultiForwardTest";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void getRequestURLIncludeTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "/other/HttpTestServlet?testname=getRequestURLIncludeTest";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            rd.include((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void getRequestURLForwardTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "/other/HttpTestServlet?testname=getRequestURLForwardTest";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void getQueryStringIncludeTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "/other/HttpTestServlet?testname=getQueryStringTestInclude";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            rd.include((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void getQueryStringForwardTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "/other/HttpTestServlet?testname=getQueryStringTestForward";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

