/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.common.servlets;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpTCKServlet
extends HttpServlet {
    private static final String TEXT_PLAIN = "text/plain";
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String TEST_HEADER = "testname";
    private static final Class<?>[] TEST_ARGS = new Class[]{HttpServletRequest.class, HttpServletResponse.class};

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void invokeTest(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        res.setContentType(TEXT_PLAIN);
        char[] temp = req.getParameter(TEST_HEADER).toCharArray();
        temp[0] = Character.toLowerCase(temp[0]);
        String test = new String(temp);
        try {
            Method method = ((Object)((Object)this)).getClass().getMethod(test, TEST_ARGS);
            method.invoke((Object)this, req, res);
        }
        catch (InvocationTargetException ite) {
            throw new ServletException(ite.getTargetException());
        }
        catch (NoSuchMethodException nsme) {
            throw new ServletException("Test: " + test + " does not exist");
        }
        catch (Throwable t) {
            throw new ServletException("Error executing test: " + test, t);
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.invokeTest(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.invokeTest(req, res);
    }
}

