/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.common.request;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import servlet.tck.common.request.Header;

public class HttpResponse {
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final String CONTENT_TYPE = "Content-Type";
    private String _encoding = "ISO-8859-1";
    private String _responseBody = null;
    private String _host;
    private int _port;
    private boolean _isSecure;
    private java.net.http.HttpResponse<String> response;

    public HttpResponse(String host, int port, boolean isSecure, String method, java.net.http.HttpResponse<String> response) {
        this._host = host;
        this._port = port;
        this._isSecure = isSecure;
        this.response = response;
    }

    public String getStatusCode() {
        return Integer.toString(this.response.statusCode());
    }

    public String getReasonPhrase() {
        return "";
    }

    public List<Header> getResponseHeaders() {
        return this.response.headers().map().entrySet().stream().map(stringListEntry -> new Header((String)stringListEntry.getKey(), (List)stringListEntry.getValue())).collect(Collectors.toList());
    }

    public List<String> getResponseHeaders(String headerName) {
        return this.response.headers().allValues(headerName);
    }

    public Optional<Header> getResponseHeader(String headerName) {
        List<String> s = this.response.headers().allValues(headerName);
        return s.isEmpty() ? Optional.empty() : Optional.of(new Header(headerName, String.join((CharSequence)", ", s)));
    }

    public byte[] getResponseBodyAsBytes() throws IOException {
        return this.getEncodedResponse().getBytes();
    }

    public byte[] getResponseBodyAsRawBytes() throws IOException {
        return this.response.body().getBytes();
    }

    public String getResponseBodyAsString() throws IOException {
        return this.getEncodedResponse();
    }

    public String getResponseBodyAsRawString() throws IOException {
        return this.response.body();
    }

    public InputStream getResponseBodyAsStream() throws IOException {
        return new ByteArrayInputStream(this.getEncodedResponse().getBytes());
    }

    public String getResponseEncoding() {
        String headerVal;
        int idx;
        Optional<String> content = this.response.headers().firstValue(CONTENT_TYPE);
        if (content.isPresent() && (idx = (headerVal = content.get()).indexOf(";charset=")) > -1) {
            this._encoding = headerVal.substring(idx + 9);
        }
        return this._encoding;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(255);
        sb.append("[RESPONSE STATUS LINE] -> ");
        sb.append(this.response.version().toString());
        sb.append(this.response.statusCode()).append(' ');
        sb.append(System.lineSeparator());
        sb.append("       [RESPONSE HEADER] -> ");
        for (Map.Entry<String, List<String>> header : this.response.headers().map().entrySet()) {
            sb.append(header.getKey()).append(':').append(header.getValue()).append(System.lineSeparator());
        }
        String resBody = this.response.body();
        if (resBody != null && !resBody.isEmpty()) {
            sb.append("------ [RESPONSE BODY] ------").append(System.lineSeparator());
            sb.append(resBody);
            sb.append("\n-----------------------------\n\n");
        }
        return sb.toString();
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public String getProtocol() {
        return this._isSecure ? "https" : "http";
    }

    private String getEncodedResponse() throws IOException {
        if (this._responseBody == null) {
            this._responseBody = this.response.body();
        }
        return this._responseBody;
    }

    public static String getEncodedStringFromStream(InputStream in, String enc) throws IOException {
        BufferedReader bin = new BufferedReader(new InputStreamReader(in, enc));
        StringBuilder sb = new StringBuilder(128);
        int ch = bin.read();
        while (ch != -1) {
            sb.append((char)ch);
            ch = bin.read();
        }
        return sb.toString();
    }
}

