/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.api.jakarta_servlet_http.readlistener;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;

public class TestListener
implements ReadListener {
    private ServletInputStream input = null;
    private ServletOutputStream output = null;
    private AsyncContext ac = null;

    TestListener(ServletInputStream in, ServletOutputStream out, AsyncContext c) {
        this.input = in;
        this.output = out;
        this.ac = c;
    }

    public void onDataAvailable() {
        try {
            StringBuilder sb = new StringBuilder();
            this.output.println("=onDataAvailable");
            int len = -1;
            byte[] b = new byte[1024];
            while (this.input.isReady() && (len = this.input.read(b)) != -1) {
                String data = new String(b, 0, len);
                sb.append("=").append(data);
            }
            this.output.print(sb.toString());
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void onAllDataRead() {
        try {
            this.output.println("=onAllDataRead");
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            this.ac.complete();
        }
    }

    public void onError(Throwable t) {
        this.ac.complete();
        t.printStackTrace();
    }
}

