/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.coder;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.websocket.common.client.ByteBufferClientEndpoint;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanBinaryDecoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanBinaryEncoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanBinaryStreamDecoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanBinaryStreamEncoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextDecoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextEncoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextStreamDecoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextStreamEncoder;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.coder.InitDestroyBinaryDecoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.coder.InitDestroyBinaryEncoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.coder.InitDestroyBinaryStreamDecoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.coder.InitDestroyBinaryStreamEncoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.coder.InitDestroyTextDecoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.coder.InitDestroyTextEncoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.coder.InitDestroyTextStreamDecoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.coder.InitDestroyTextStreamEncoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.coder.WSCEndpointWithBinaryDecoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.coder.WSCEndpointWithBinaryDecoders;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.coder.WSCEndpointWithBinaryEncoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.coder.WSCEndpointWithBinaryStreamDecoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.coder.WSCEndpointWithBinaryStreamEncoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.coder.WSCEndpointWithTextDecoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.coder.WSCEndpointWithTextDecoders;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.coder.WSCEndpointWithTextEncoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.coder.WSCEndpointWithTextStreamDecoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.coder.WSCEndpointWithTextStreamEncoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.coder.WSCLoggerServer;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.coder.WillDecodeFirstBinaryDecoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.coder.WillDecodeFirstTextDecoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.coder.WillDecodeSecondBinaryDecoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.coder.WillDecodeSecondTextDecoder;
import java.nio.ByteBuffer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSClientIT
extends WebSocketCommonClient {
    protected static final String ECHO = "Echo message";

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_ee_coder_web.war");
        archive.addClasses(new Class[]{StringBean.class, StringBeanBinaryDecoder.class, StringBeanBinaryEncoder.class, StringBeanBinaryStreamEncoder.class, StringBeanBinaryStreamDecoder.class, StringBeanTextEncoder.class, StringBeanTextDecoder.class, StringBeanTextStreamEncoder.class, StringBeanTextStreamDecoder.class});
        archive.addClasses(new Class[]{IOUtil.class});
        archive.addPackages(false, Filters.exclude((Class[])new Class[]{WSClientIT.class}), new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.coder"});
        return archive;
    }

    public WSClientIT() throws Exception {
        this.setContextRoot("wsc_ee_coder_web");
    }

    @Test
    public void textEncoderInitDestroyTest() throws Exception {
        this.invokeClear();
        this.invokeEcho("textencoder");
        this.invokeGetInit(InitDestroyTextEncoder.class);
        this.invokeGetDestroy(InitDestroyTextEncoder.class);
    }

    @Test
    public void textStreamEncoderInitDestroyTest() throws Exception {
        this.invokeClear();
        this.invokeEcho("textstreamencoder");
        this.invokeGetInit(InitDestroyTextStreamEncoder.class);
        this.invokeGetDestroy(InitDestroyTextStreamEncoder.class);
    }

    @Test
    public void binaryEncoderInitDestroyTest() throws Exception {
        this.invokeClear();
        this.invokeBinaryEncoderEcho("binaryencoder");
        this.invokeGetInit(InitDestroyBinaryEncoder.class);
        this.invokeGetDestroy(InitDestroyBinaryEncoder.class);
    }

    @Test
    public void binaryStreamEncoderInitDestroyTest() throws Exception {
        this.invokeClear();
        this.invokeBinaryEncoderEcho("binarystreamencoder");
        this.invokeGetInit(InitDestroyBinaryStreamEncoder.class);
        this.invokeGetDestroy(InitDestroyBinaryStreamEncoder.class);
    }

    @Test
    public void textDecoderInitDestroyTest() throws Exception {
        this.invokeClear();
        this.invokeEcho("textdecoder");
        this.invokeGetInit(InitDestroyTextDecoder.class);
        this.invokeGetDestroy(InitDestroyTextDecoder.class);
    }

    @Test
    public void textStreamDecoderInitDestroyTest() throws Exception {
        this.invokeClear();
        this.invokeEcho("textstreamdecoder");
        this.invokeGetInit(InitDestroyTextStreamDecoder.class);
        this.invokeGetDestroy(InitDestroyTextStreamDecoder.class);
    }

    @Test
    public void binaryDecoderInitDestroyTest() throws Exception {
        this.invokeClear();
        this.invokeBinaryDecoderEcho("binarydecoder");
        this.invokeGetInit(InitDestroyBinaryDecoder.class);
        this.invokeGetDestroy(InitDestroyBinaryDecoder.class);
    }

    @Test
    public void binaryStreamDecoderInitDestroyTest() throws Exception {
        this.invokeClear();
        this.invokeBinaryDecoderEcho("binarystreamdecoder");
        this.invokeGetInit(InitDestroyBinaryStreamDecoder.class);
        this.invokeGetDestroy(InitDestroyBinaryStreamDecoder.class);
    }

    @Test
    public void textEncoderEncodeTest() throws Exception {
        this.invokeClear();
        this.invokeEcho("textencoder");
        this.invokeGetCode(InitDestroyTextEncoder.class);
    }

    @Test
    public void textStreamEncoderEncodeTest() throws Exception {
        this.invokeClear();
        this.invokeEcho("textstreamencoder");
        this.invokeGetCode(InitDestroyTextStreamEncoder.class);
    }

    @Test
    public void binaryEncoderEncodeTest() throws Exception {
        this.invokeClear();
        this.invokeBinaryEncoderEcho("binaryencoder");
        this.invokeGetCode(InitDestroyBinaryEncoder.class);
    }

    @Test
    public void binaryStreamEncoderEncodeTest() throws Exception {
        this.invokeClear();
        this.invokeBinaryEncoderEcho("binarystreamencoder");
        this.invokeGetCode(InitDestroyBinaryStreamEncoder.class);
    }

    @Test
    public void textDecoderDecodeTest() throws Exception {
        this.invokeClear();
        this.invokeEcho("textdecoder");
        this.invokeGetCode(InitDestroyTextDecoder.class);
        this.invokeGetWillCode(InitDestroyTextDecoder.class);
    }

    @Test
    public void textStreamDecoderDecodeTest() throws Exception {
        this.invokeClear();
        this.invokeEcho("textstreamdecoder");
        this.invokeGetCode(InitDestroyTextStreamDecoder.class);
    }

    @Test
    public void binaryDecoderDecodeTest() throws Exception {
        this.invokeClear();
        this.invokeBinaryDecoderEcho("binarydecoder");
        this.invokeGetCode(InitDestroyBinaryDecoder.class);
        this.invokeGetWillCode(InitDestroyBinaryDecoder.class);
    }

    @Test
    public void binaryStreamDecoderDecodeTest() throws Exception {
        this.invokeClear();
        this.invokeBinaryDecoderEcho("binarystreamdecoder");
        this.invokeGetCode(InitDestroyBinaryStreamDecoder.class);
    }

    @Test
    public void binaryDecoderWillDecodeTest() throws Exception {
        this.invokeClear();
        this.invokeBinaryDecoderEcho("binarywilldecode");
        this.invokeGetWillCode(WillDecodeFirstBinaryDecoder.class, WillDecodeSecondBinaryDecoder.class);
        this.setProperty(WebSocketCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, WillDecodeFirstBinaryDecoder.class.getName());
        this.invokeGetCode(WillDecodeSecondBinaryDecoder.class);
    }

    @Test
    public void textDecoderWillDecodeTest() throws Exception {
        this.invokeClear();
        this.invokeEcho("textwilldecode");
        this.invokeGetWillCode(WillDecodeFirstTextDecoder.class, WillDecodeSecondTextDecoder.class);
        this.setProperty(WebSocketCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, WillDecodeFirstTextDecoder.class.getName());
        this.invokeGetCode(WillDecodeSecondTextDecoder.class);
    }

    @Test
    public void textEncoderInitDestroyOnClientTest() throws Exception {
        this.clientClear();
        this.setAnnotatedClientEndpointInstance(new WSCEndpointWithTextEncoder());
        this.invoke("simpleecho", new StringBean(ECHO), new String[]{ECHO});
        this.assertInit(InitDestroyTextEncoder.class);
        this.assertDestroy(InitDestroyTextEncoder.class);
    }

    @Test
    public void textStreamEncoderInitDestroyOnClientTest() throws Exception {
        this.clientClear();
        this.setAnnotatedClientEndpointInstance(new WSCEndpointWithTextStreamEncoder());
        this.invoke("simpleecho", new StringBean(ECHO), new String[]{ECHO});
        this.assertInit(InitDestroyTextStreamEncoder.class);
        this.assertDestroy(InitDestroyTextStreamEncoder.class);
    }

    @Test
    public void binaryEncoderInitDestroyOnClientTest() throws Exception {
        this.clientClear();
        this.setAnnotatedClientEndpointInstance(new WSCEndpointWithBinaryEncoder());
        this.invoke("simpleecho", new StringBean(ECHO), new String[]{ECHO});
        this.assertInit(InitDestroyBinaryEncoder.class);
        this.assertDestroy(InitDestroyBinaryEncoder.class);
    }

    @Test
    public void binaryStreamEncoderInitDestroyOnClientTest() throws Exception {
        this.clientClear();
        this.setAnnotatedClientEndpointInstance(new WSCEndpointWithBinaryStreamEncoder());
        this.invoke("simpleecho", new StringBean(ECHO), new String[]{ECHO});
        this.assertInit(InitDestroyBinaryStreamEncoder.class);
        this.assertDestroy(InitDestroyBinaryStreamEncoder.class);
    }

    @Test
    public void textDecoderInitDestroyOnClientTest() throws Exception {
        this.clientClear();
        this.setAnnotatedClientEndpointInstance(new WSCEndpointWithTextDecoder());
        this.invoke("simpleecho", ECHO, new String[]{ECHO});
        this.assertInit(InitDestroyTextDecoder.class);
        this.assertDestroy(InitDestroyTextDecoder.class);
    }

    @Test
    public void textStreamDecoderInitDestroyOnClientTest() throws Exception {
        this.clientClear();
        this.setAnnotatedClientEndpointInstance(new WSCEndpointWithTextStreamDecoder());
        this.invoke("simpleecho", ECHO, new String[]{ECHO});
        this.assertInit(InitDestroyTextStreamDecoder.class);
        this.assertDestroy(InitDestroyTextStreamDecoder.class);
    }

    @Test
    public void binaryDecoderInitDestroyOnClientTest() throws Exception {
        this.clientClear();
        this.setAnnotatedClientEndpointInstance(new WSCEndpointWithBinaryDecoder());
        this.invoke("simplebin", ECHO, new String[]{ECHO});
        this.assertInit(InitDestroyBinaryDecoder.class);
        this.assertDestroy(InitDestroyBinaryDecoder.class);
    }

    @Test
    public void binaryStreamDecoderInitDestroyOnClientTest() throws Exception {
        this.clientClear();
        this.setAnnotatedClientEndpointInstance(new WSCEndpointWithBinaryStreamDecoder());
        this.invoke("simplebin", ECHO, new String[]{ECHO});
        this.assertInit(InitDestroyBinaryStreamDecoder.class);
        this.assertDestroy(InitDestroyBinaryStreamDecoder.class);
    }

    @Test
    public void textEncoderEncodeOnClientTest() throws Exception {
        this.clientClear();
        this.setAnnotatedClientEndpointInstance(new WSCEndpointWithTextEncoder());
        this.invoke("simpleecho", new StringBean(ECHO), new String[]{ECHO});
        this.assertCode(InitDestroyTextEncoder.class);
    }

    @Test
    public void textStreamEncoderEncodeOnClientTest() throws Exception {
        this.clientClear();
        this.setAnnotatedClientEndpointInstance(new WSCEndpointWithTextStreamEncoder());
        this.invoke("simpleecho", new StringBean(ECHO), new String[]{ECHO});
        this.assertCode(InitDestroyTextStreamEncoder.class);
    }

    @Test
    public void binaryEncoderEncodeOnClientTest() throws Exception {
        this.clientClear();
        this.setAnnotatedClientEndpointInstance(new WSCEndpointWithBinaryEncoder());
        this.invoke("simpleecho", new StringBean(ECHO), new String[]{ECHO});
        this.assertCode(InitDestroyBinaryEncoder.class);
    }

    @Test
    public void binaryStreamEncoderEncodeOnClientTest() throws Exception {
        this.clientClear();
        this.setAnnotatedClientEndpointInstance(new WSCEndpointWithBinaryStreamEncoder());
        this.invoke("simpleecho", new StringBean(ECHO), new String[]{ECHO});
        this.assertCode(InitDestroyBinaryStreamEncoder.class);
    }

    @Test
    public void textDecoderDecodeOnClientTest() throws Exception {
        this.clientClear();
        this.setAnnotatedClientEndpointInstance(new WSCEndpointWithTextDecoder());
        this.invoke("simpleecho", ECHO, new String[]{ECHO});
        this.assertCode(InitDestroyTextDecoder.class);
        this.assertWillCode(InitDestroyTextDecoder.class);
    }

    @Test
    public void textStreamDecoderDecodeOnClientTest() throws Exception {
        this.clientClear();
        this.setAnnotatedClientEndpointInstance(new WSCEndpointWithTextStreamDecoder());
        this.invoke("simpleecho", ECHO, new String[]{ECHO});
        this.assertCode(InitDestroyTextStreamDecoder.class);
    }

    @Test
    public void binaryDecoderDecodeOnClientTest() throws Exception {
        this.clientClear();
        this.setAnnotatedClientEndpointInstance(new WSCEndpointWithBinaryDecoder());
        this.invoke("simplebin", ECHO, new String[]{ECHO});
        this.assertCode(InitDestroyBinaryDecoder.class);
        this.assertWillCode(InitDestroyBinaryDecoder.class);
    }

    @Test
    public void binaryStreamDecoderDecodeOnClientTest() throws Exception {
        this.clientClear();
        this.setAnnotatedClientEndpointInstance(new WSCEndpointWithBinaryStreamDecoder());
        this.invoke("simplebin", ECHO, new String[]{ECHO});
        this.assertCode(InitDestroyBinaryStreamDecoder.class);
    }

    @Test
    public void binaryDecoderWillDecodeOnClientTest() throws Exception {
        this.clientClear();
        this.setAnnotatedClientEndpointInstance(new WSCEndpointWithBinaryDecoders());
        this.invoke("simplebin", ECHO, new String[]{ECHO});
        this.assertWillCode(WillDecodeFirstBinaryDecoder.class);
        this.assertWillCode(WillDecodeSecondBinaryDecoder.class);
        this.assertNotCode(WillDecodeFirstBinaryDecoder.class);
        this.assertCode(WillDecodeSecondBinaryDecoder.class);
    }

    @Test
    public void textDecoderWillDecodeOnClientTest() throws Exception {
        this.clientClear();
        this.setAnnotatedClientEndpointInstance(new WSCEndpointWithTextDecoders());
        this.invoke("simpleecho", ECHO, new String[]{ECHO});
        this.assertWillCode(WillDecodeFirstTextDecoder.class);
        this.assertWillCode(WillDecodeSecondTextDecoder.class);
        this.assertNotCode(WillDecodeFirstTextDecoder.class);
        this.assertCode(WillDecodeSecondTextDecoder.class);
    }

    private void invokeClear() throws Exception {
        this.invokeLogger("clearall", "clearall");
    }

    private void invokeEcho(String endpoint) throws Exception {
        this.invoke(endpoint, ECHO, new String[]{ECHO});
    }

    private void invokeBinaryEncoderEcho(String endpoint) throws Exception {
        this.setClientEndpoint(ByteBufferClientEndpoint.class);
        this.invokeEcho(endpoint);
    }

    private void invokeBinaryDecoderEcho(String endpoint) throws Exception {
        this.setEntity(new Object[]{ByteBuffer.wrap(ECHO.getBytes())});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{endpoint}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO);
        this.invoke();
    }

    private void invokeGetInit(Class<?> searchClazz) throws Exception {
        this.invokeLogger("getinit", searchClazz.getName());
    }

    private void invokeGetDestroy(Class<?> searchClazz) throws Exception {
        TestUtil.sleepMsec((int)500);
        this.invokeLogger("getdestroy", searchClazz.getName());
    }

    private void invokeGetCode(Class<?> ... searchClasses) throws Exception {
        for (Class<?> searchClazz : searchClasses) {
            this.invokeLogger("getcode", searchClazz.getName());
        }
    }

    private void invokeGetWillCode(Class<?> ... searchClasses) throws Exception {
        for (Class<?> searchClazz : searchClasses) {
            this.invokeLogger("getwillcode", searchClazz.getName());
        }
    }

    private void invokeLogger(String method, String search) throws Exception {
        this.invoke("logger", method, new String[]{search});
    }

    protected void clientClear() {
        WSCLoggerServer.operation("clearall");
    }

    protected void assertInit(Class<?> searchClazz) throws Exception {
        String log = WSCLoggerServer.operation("getinit");
        WSClientIT.assertContains((String)log, (String)searchClazz.getName(), (Object[])new Object[]{searchClazz.getName(), "has not been found in a list of classes calling the init() method, only [", log, "] has been found"});
        WSClientIT.logMsg((Object[])new Object[]{"init() has been called on", searchClazz, "as expected"});
    }

    protected void assertDestroy(Class<?> searchClazz) throws Exception {
        System.gc();
        TestUtil.sleepMsec((int)500);
        String log = WSCLoggerServer.operation("getdestroy");
        WSClientIT.assertContains((String)log, (String)searchClazz.getName(), (Object[])new Object[]{searchClazz.getName(), "has not been found in a list of classes calling the destroy() method, only [", log, "] has been found"});
        WSClientIT.logMsg((Object[])new Object[]{"destroy() has been called on", searchClazz, "as expected"});
    }

    protected void assertCode(Class<?> searchClass) throws Exception {
        String log = WSCLoggerServer.operation("getcode");
        WSClientIT.assertContains((String)log, (String)searchClass.getName(), (Object[])new Object[]{searchClass.getName(), "has not been found in a list of classes calling the code() method, only [", log, "] has been found"});
        WSClientIT.logMsg((Object[])new Object[]{"code() has been called on", searchClass, "as expected"});
    }

    protected void assertWillCode(Class<?> searchClass) throws Exception {
        String log = WSCLoggerServer.operation("getwillcode");
        WSClientIT.assertContains((String)log, (String)searchClass.getName(), (Object[])new Object[]{searchClass.getName(), "has not been found in a list of classes calling the willCode() method, only [", log, "] has been found"});
        WSClientIT.logMsg((Object[])new Object[]{"willCode() has been called on", searchClass, "as expected"});
    }

    protected void assertNotCode(Class<?> searchClass) throws Exception {
        String log = WSCLoggerServer.operation("getcode");
        WSClientIT.assertNotContains((String)log, (String)searchClass.getName(), (Object[])new Object[]{searchClass.getName(), "has unexpectedly been found in a list of classes calling the code() method"});
        WSClientIT.logMsg((Object[])new Object[]{"code() has not been called on", searchClass, "as expected"});
    }
}

