/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efbt.ecore4reg.dsl.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import org.eclipse.efbt.ecore4reg.model.ecore4reg.ELAttribute;
import org.eclipse.efbt.ecore4reg.model.ecore4reg.ELClass;
import org.eclipse.efbt.ecore4reg.model.ecore4reg.ELClassifier;
import org.eclipse.efbt.ecore4reg.model.ecore4reg.ELDataType;
import org.eclipse.efbt.ecore4reg.model.ecore4reg.ELEnum;
import org.eclipse.efbt.ecore4reg.model.ecore4reg.ELEnumLiteral;
import org.eclipse.efbt.ecore4reg.model.ecore4reg.ELOperation;
import org.eclipse.efbt.ecore4reg.model.ecore4reg.ELPackage;
import org.eclipse.efbt.ecore4reg.model.ecore4reg.ELParameter;
import org.eclipse.efbt.ecore4reg.model.ecore4reg.ELReference;
import org.eclipse.efbt.ecore4reg.model.ecore4reg.ELStructuralFeature;
import org.eclipse.efbt.ecore4reg.model.ecore4reg.Import;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class Ecore4RegGenerator
extends AbstractGenerator {
    public void doGenerate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext context) {
        System.out.println("resource = " + resource);
        Iterable _filter = Iterables.filter((Iterable)IteratorExtensions.toIterable((Iterator)resource.getAllContents()), ELPackage.class);
        for (ELPackage elpackage : _filter) {
            this.processPackage(elpackage, fsa);
            this.createXCoreForPackage(elpackage, fsa, resource);
        }
    }

    public void createXCoreForPackage(ELPackage elpackage, IFileSystemAccess2 fsa, Resource resource) {
        boolean _notEquals;
        String _name = elpackage.getName();
        String _plus = String.valueOf(_name) + ".xcore";
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("package ");
        String _name_1 = elpackage.getName();
        _builder.append(_name_1);
        _builder.newLineIfNotEmpty();
        String _trim = elpackage.getName().trim();
        boolean bl = _notEquals = !Objects.equal((Object)_trim, (Object)"types");
        if (_notEquals) {
            EList _imports = elpackage.getImports();
            for (Import theImport : _imports) {
                boolean _notEquals_1;
                _builder.newLine();
                String _trim_1 = theImport.getImportedNamespace().trim();
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)_trim_1, (Object)"types.*");
                if (!_notEquals_1) continue;
                _builder.append("import ");
                String _importedNamespace = theImport.getImportedNamespace();
                _builder.append(_importedNamespace);
                _builder.append(" ");
                _builder.newLineIfNotEmpty();
            }
            Iterable _filter = Iterables.filter((Iterable)elpackage.getEClassifiers(), ELClass.class);
            for (ELClass elclass : _filter) {
                boolean _equals;
                boolean _isEAbstract = elclass.isEAbstract();
                if (_isEAbstract) {
                    _builder.append("abstract ");
                }
                _builder.append("class ");
                String _name_2 = elclass.getName();
                _builder.append(_name_2);
                _builder.append(" ");
                int _length = ((Object[])Conversions.unwrapArray((Object)elclass.getESuperTypes(), Object.class)).length;
                boolean bl3 = _equals = _length == 1;
                if (_equals) {
                    _builder.append(" extends ");
                    String _name_3 = ((ELClass)elclass.getESuperTypes().get(0)).getName();
                    _builder.append(_name_3);
                    _builder.append(" ");
                }
                _builder.append("{");
                _builder.newLineIfNotEmpty();
                EList _eStructuralFeatures = elclass.getEStructuralFeatures();
                for (ELStructuralFeature elmember : _eStructuralFeatures) {
                    if (elmember instanceof ELAttribute) {
                        boolean _equals_1;
                        _builder.append(" \t");
                        boolean _isID = ((ELAttribute)elmember).isID();
                        if (_isID) {
                            _builder.append("id ");
                        }
                        String _name_4 = ((ELAttribute)elmember).getEAttributeType().getName();
                        _builder.append(_name_4);
                        _builder.append(" ");
                        int _upperBound = ((ELAttribute)elmember).getUpperBound();
                        boolean bl4 = _equals_1 = _upperBound == -1;
                        if (_equals_1) {
                            _builder.append("[]  ");
                        } else {
                            boolean _not;
                            boolean bl5 = _not = ((ELAttribute)elmember).getLowerBound() != 0 || ((ELAttribute)elmember).getUpperBound() != 1 && ((ELAttribute)elmember).getUpperBound() != 0;
                            if (_not) {
                                _builder.append("[");
                                int _lowerBound = ((ELAttribute)elmember).getLowerBound();
                                _builder.append((Object)_lowerBound);
                                _builder.append("..");
                                int _upperBound_1 = ((ELAttribute)elmember).getUpperBound();
                                _builder.append((Object)_upperBound_1);
                                _builder.append("]");
                            }
                        }
                        _builder.append(" ");
                        String _name_5 = ((ELAttribute)elmember).getName();
                        _builder.append(_name_5);
                        _builder.append(" ");
                    }
                    _builder.newLineIfNotEmpty();
                    if (elmember instanceof ELReference) {
                        boolean _equals_2;
                        _builder.append(" \t");
                        boolean _isContainment = ((ELReference)elmember).isContainment();
                        if (_isContainment) {
                            _builder.append("contains ");
                        } else {
                            _builder.append("refers");
                        }
                        _builder.append(" ");
                        String _name_6 = ((ELReference)elmember).getEType().getName();
                        _builder.append(_name_6);
                        _builder.append(" ");
                        int _upperBound_2 = ((ELReference)elmember).getUpperBound();
                        boolean bl6 = _equals_2 = _upperBound_2 == -1;
                        if (_equals_2) {
                            _builder.append("[]  ");
                        } else {
                            boolean _not_1;
                            boolean bl7 = _not_1 = ((ELReference)elmember).getLowerBound() != 0 || ((ELReference)elmember).getUpperBound() != 1 && ((ELReference)elmember).getUpperBound() != 0;
                            if (_not_1) {
                                _builder.append("[");
                                int _lowerBound_1 = ((ELReference)elmember).getLowerBound();
                                _builder.append((Object)_lowerBound_1);
                                _builder.append("..");
                                int _upperBound_3 = ((ELReference)elmember).getUpperBound();
                                _builder.append((Object)_upperBound_3);
                                _builder.append("]");
                            }
                        }
                        _builder.append(" ");
                        String _name_7 = ((ELReference)elmember).getName();
                        _builder.append(_name_7);
                    }
                    _builder.append("\t");
                    _builder.newLineIfNotEmpty();
                }
                EList _eOperations = elclass.getEOperations();
                for (ELOperation eloperation : _eOperations) {
                    boolean _tripleNotEquals;
                    boolean _equals_4;
                    boolean _equals_3;
                    if (!(eloperation instanceof ELOperation)) continue;
                    _builder.append(" \top ");
                    String _name_8 = eloperation.getEType().getName();
                    _builder.append(_name_8);
                    _builder.append(" ");
                    int _upperBound_4 = eloperation.getUpperBound();
                    boolean bl8 = _equals_3 = _upperBound_4 == -1;
                    if (_equals_3) {
                        _builder.append("[]  ");
                    } else {
                        boolean _not_2;
                        boolean bl9 = _not_2 = eloperation.getLowerBound() != 0 || eloperation.getUpperBound() != 1 && eloperation.getUpperBound() != 0;
                        if (_not_2) {
                            _builder.append("[");
                            int _lowerBound_2 = eloperation.getLowerBound();
                            _builder.append((Object)_lowerBound_2);
                            _builder.append("..");
                            int _upperBound_5 = eloperation.getUpperBound();
                            _builder.append((Object)_upperBound_5);
                            _builder.append("]");
                        }
                    }
                    _builder.append(" ");
                    String _name_9 = eloperation.getName();
                    _builder.append(_name_9);
                    int _size = eloperation.getEParameters().size();
                    boolean bl10 = _equals_4 = _size == 0;
                    if (_equals_4) {
                        _builder.append("()");
                    }
                    EList _eParameters = eloperation.getEParameters();
                    boolean _hasElements = false;
                    for (ELParameter eparam : _eParameters) {
                        if (!_hasElements) {
                            _hasElements = true;
                            _builder.append("(");
                        } else {
                            _builder.appendImmediate((Object)",", "");
                        }
                        String _name_10 = eparam.getEType().getName();
                        _builder.append(_name_10);
                        _builder.append(" ");
                        String _name_11 = eparam.getName();
                        _builder.append(_name_11);
                    }
                    if (_hasElements) {
                        _builder.append(")");
                    }
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("{");
                    _builder.newLine();
                    String _body = eloperation.getBody();
                    boolean bl11 = _tripleNotEquals = _body != null;
                    if (_tripleNotEquals) {
                        _builder.append("          ");
                        String _findXCoreSubstring = this.findXCoreSubstring(eloperation.getBody());
                        _builder.append(_findXCoreSubstring);
                        _builder.newLineIfNotEmpty();
                    } else {
                        String _name_12 = eloperation.getEType().getName();
                        boolean _equals_5 = Objects.equal((Object)_name_12, (Object)"double");
                        if (_equals_5) {
                            _builder.append("        return 0");
                            _builder.newLineIfNotEmpty();
                        } else {
                            String _name_13 = eloperation.getEType().getName();
                            boolean _equals_6 = Objects.equal((Object)_name_13, (Object)"int");
                            if (_equals_6) {
                                _builder.append("        return 0");
                                _builder.newLineIfNotEmpty();
                            } else {
                                String _name_14 = eloperation.getEType().getName();
                                boolean _equals_7 = Objects.equal((Object)_name_14, (Object)"boolean");
                                if (_equals_7) {
                                    _builder.append("        return true");
                                    _builder.newLineIfNotEmpty();
                                }
                            }
                        }
                    }
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                }
                _builder.append("}");
                _builder.newLine();
            }
            Iterable _filter_1 = Iterables.filter((Iterable)elpackage.getEClassifiers(), ELEnum.class);
            for (ELEnum elEnum : _filter_1) {
                _builder.append("enum ");
                String _name_15 = elEnum.getName();
                _builder.append(_name_15);
                _builder.append(" {");
                EList _eLiterals = elEnum.getELiterals();
                for (ELEnumLiteral elliteral : _eLiterals) {
                    _builder.append("  ");
                    String _name_16 = elliteral.getName();
                    _builder.append(_name_16);
                    _builder.append("  as \"");
                    String _literal = elliteral.getLiteral();
                    _builder.append(_literal);
                    _builder.append("\"  = ");
                    int _value = elliteral.getValue();
                    _builder.append((Object)_value);
                    _builder.append(" ");
                }
                _builder.append("}");
                _builder.newLineIfNotEmpty();
            }
            Iterable _iterable = IteratorExtensions.toIterable((Iterator)Iterators.filter((Iterator)resource.getAllContents(), ELDataType.class));
            for (ELDataType xDataType : _iterable) {
                if (!(xDataType instanceof ELEnum)) {
                    _builder.append("type  ");
                    String _name_17 = xDataType.getName();
                    _builder.append(_name_17);
                    _builder.append(" wraps ");
                    String _name_18 = xDataType.getName();
                    boolean _equals_8 = Objects.equal((Object)_name_18, (Object)"Date");
                    if (_equals_8) {
                        _builder.append("java.util.Date ");
                    } else {
                        String _name_19 = xDataType.getName();
                        _builder.append(_name_19);
                        _builder.append(" ");
                    }
                    _builder.append(" ");
                    _builder.newLineIfNotEmpty();
                }
                _builder.newLine();
            }
        }
        fsa.generateFile(_plus, (CharSequence)_builder);
    }

    public EPackage processPackage(ELPackage elpackage, IFileSystemAccess2 fsa) {
        try {
            EList _eOperations;
            EList _eStructuralFeatures;
            new BasicEList();
            BasicEList dependantEcorePackages = new BasicEList();
            BasicEList processedELPackages = new BasicEList();
            String _name = elpackage.getName();
            String _plus = "package =  " + _name;
            System.out.println(_plus);
            EPackage ecore_package = EcoreFactory.eINSTANCE.createEPackage();
            ecore_package.setName(elpackage.getName());
            String _nsURI = elpackage.getNsURI();
            String _plus_1 = "http://www.eclipse.org/efbt/" + _nsURI;
            ecore_package.setNsURI(_plus_1);
            ecore_package.setNsPrefix(elpackage.getName());
            EList _eClassifiers = elpackage.getEClassifiers();
            for (ELClassifier classifier : _eClassifiers) {
                boolean _greaterThan;
                String _name_1 = classifier.getName();
                String _plus_2 = "classifier0 = " + _name_1;
                System.out.println(_plus_2);
                if (classifier instanceof ELEnum) {
                    EEnum e_enum = EcoreFactory.eINSTANCE.createEEnum();
                    e_enum.setName(((ELEnum)classifier).getName());
                    EList _eLiterals = ((ELEnum)classifier).getELiterals();
                    for (ELEnumLiteral literal : _eLiterals) {
                        EEnumLiteral e_enum_literal = EcoreFactory.eINSTANCE.createEEnumLiteral();
                        e_enum_literal.setName(literal.getName());
                        e_enum_literal.setValue(literal.getValue());
                        e_enum_literal.setLiteral(literal.getLiteral());
                        e_enum.getELiterals().add((Object)e_enum_literal);
                    }
                    ecore_package.getEClassifiers().add((Object)e_enum);
                }
                if (!(classifier instanceof ELClass)) continue;
                Iterator e_class = EcoreFactory.eINSTANCE.createEClass();
                e_class.setName(((ELClass)classifier).getName());
                e_class.setAbstract(((ELClass)classifier).isEAbstract());
                int _size = ((ELClass)classifier).getESuperTypes().size();
                boolean bl = _greaterThan = _size > 0;
                if (_greaterThan) {
                    ELPackage superTypesPackage = ((ELClass)((ELClass)classifier).getESuperTypes().get(0)).getEPackage();
                    String _name_2 = superTypesPackage.getName();
                    String _plus_3 = "superTypesPackage" + _name_2;
                    System.out.println(_plus_3);
                    if (processedELPackages.indexOf((Object)superTypesPackage) == -1 && superTypesPackage != null && !Objects.equal((Object)superTypesPackage.getName(), (Object)"types") && !Objects.equal((Object)superTypesPackage, (Object)elpackage)) {
                        processedELPackages.add((Object)superTypesPackage);
                        dependantEcorePackages.add((Object)this.processPackage(superTypesPackage, fsa));
                    }
                    String superTypeName = ((ELClass)((ELClass)classifier).getESuperTypes().get(0)).getName();
                    EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
                    annotation.setSource("temp");
                    annotation.getDetails().put((Object)"superTypeName", (Object)superTypeName);
                    e_class.getEAnnotations().add((Object)annotation);
                }
                _eStructuralFeatures = ((ELClass)classifier).getEStructuralFeatures();
                for (EStructuralFeature structural_feature : _eStructuralFeatures) {
                    boolean _notEquals_1;
                    if (structural_feature instanceof ELAttribute) {
                        ELDataType _eAttributeType;
                        boolean _notEquals;
                        EAttribute e_attribute = EcoreFactory.eINSTANCE.createEAttribute();
                        e_class.getEStructuralFeatures().add((Object)e_attribute);
                        e_attribute.setName(((ELAttribute)structural_feature).getName());
                        int _upperBound = ((ELAttribute)structural_feature).getUpperBound();
                        boolean bl2 = _notEquals = _upperBound != 0;
                        if (_notEquals) {
                            e_attribute.setUpperBound(((ELAttribute)structural_feature).getUpperBound());
                        } else {
                            e_attribute.setUpperBound(1);
                        }
                        e_attribute.setLowerBound(((ELAttribute)structural_feature).getLowerBound());
                        String type_name = ((ELAttribute)structural_feature).getEAttributeType().getName();
                        boolean _isID = ((ELAttribute)structural_feature).isID();
                        if (_isID) {
                            e_attribute.setID(true);
                        }
                        if ((_eAttributeType = ((ELAttribute)structural_feature).getEAttributeType()) instanceof ELEnum) {
                            String attribute_type_name = ((ELAttribute)structural_feature).getEAttributeType().getName();
                            ELPackage enumsPackage = ((ELAttribute)structural_feature).getEAttributeType().getEPackage();
                            System.out.println("enumsPackage1" + enumsPackage);
                            if (processedELPackages.indexOf((Object)enumsPackage) == -1 && enumsPackage != null && !Objects.equal((Object)enumsPackage.getName(), (Object)"types") && !Objects.equal((Object)enumsPackage, (Object)elpackage)) {
                                processedELPackages.add((Object)enumsPackage);
                                dependantEcorePackages.add((Object)this.processPackage(enumsPackage, fsa));
                            }
                            EAnnotation annotation_1 = EcoreFactory.eINSTANCE.createEAnnotation();
                            annotation_1.setSource("temp");
                            annotation_1.getDetails().put((Object)"attribute_type_name", (Object)attribute_type_name);
                            e_attribute.getEAnnotations().add((Object)annotation_1);
                        } else {
                            boolean _equals = Objects.equal((Object)type_name, (Object)"double");
                            if (_equals) {
                                e_attribute.setEType((EClassifier)EcorePackage.Literals.EDOUBLE);
                            } else {
                                boolean _equals_1 = Objects.equal((Object)type_name, (Object)"String");
                                if (_equals_1) {
                                    e_attribute.setEType((EClassifier)EcorePackage.Literals.ESTRING);
                                } else {
                                    boolean _equals_2 = Objects.equal((Object)type_name, (Object)"String");
                                    if (_equals_2) {
                                        e_attribute.setEType((EClassifier)EcorePackage.Literals.ESTRING);
                                    } else {
                                        boolean _equals_3 = Objects.equal((Object)type_name, (Object)"int");
                                        if (_equals_3) {
                                            e_attribute.setEType((EClassifier)EcorePackage.Literals.EINT);
                                        } else {
                                            boolean _equals_4 = Objects.equal((Object)type_name, (Object)"Date");
                                            if (_equals_4) {
                                                e_attribute.setEType((EClassifier)EcorePackage.Literals.EDATE);
                                            } else {
                                                boolean _equals_5 = Objects.equal((Object)type_name, (Object)"boolean");
                                                if (_equals_5) {
                                                    e_attribute.setEType((EClassifier)EcorePackage.Literals.EBOOLEAN);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (!(structural_feature instanceof ELReference)) continue;
                    Iterator e_reference = EcoreFactory.eINSTANCE.createEReference();
                    e_reference.setName(((ELReference)structural_feature).getName());
                    int _upperBound_1 = ((ELReference)structural_feature).getUpperBound();
                    boolean bl3 = _notEquals_1 = _upperBound_1 != 0;
                    if (_notEquals_1) {
                        e_reference.setUpperBound(((ELReference)structural_feature).getUpperBound());
                    } else {
                        e_reference.setUpperBound(1);
                    }
                    e_reference.setLowerBound(((ELReference)structural_feature).getLowerBound());
                    e_reference.setContainment(((ELReference)structural_feature).isContainment());
                    e_class.getEStructuralFeatures().add((Object)e_reference);
                    String type_name_1 = ((ELReference)structural_feature).getEType().getName();
                    ELPackage referenceTypePackage = ((ELReference)structural_feature).getEType().getEPackage();
                    System.out.println("referenceTypePackage" + referenceTypePackage);
                    if (processedELPackages.indexOf((Object)referenceTypePackage) == -1 && referenceTypePackage != null && !Objects.equal((Object)referenceTypePackage.getName(), (Object)"types") && !Objects.equal((Object)referenceTypePackage, (Object)elpackage)) {
                        processedELPackages.add((Object)referenceTypePackage);
                        dependantEcorePackages.add((Object)this.processPackage(referenceTypePackage, fsa));
                    }
                    EAnnotation annotation_2 = EcoreFactory.eINSTANCE.createEAnnotation();
                    annotation_2.setSource("temp");
                    annotation_2.getDetails().put((Object)"type", (Object)type_name_1);
                    e_reference.getEAnnotations().add((Object)annotation_2);
                }
                _eOperations = ((ELClass)classifier).getEOperations();
                for (EOperation operation : _eOperations) {
                    boolean _notEquals;
                    EOperation e_operation = EcoreFactory.eINSTANCE.createEOperation();
                    e_operation.setName(operation.getName());
                    int _upperBound = operation.getUpperBound();
                    boolean bl4 = _notEquals = _upperBound != 0;
                    if (_notEquals) {
                        e_operation.setUpperBound(operation.getUpperBound());
                    } else {
                        e_operation.setUpperBound(1);
                    }
                    e_class.getEOperations().add((Object)e_operation);
                    String type_name = operation.getEType().getName();
                    EAnnotation annotation_1 = EcoreFactory.eINSTANCE.createEAnnotation();
                    annotation_1.setSource("temp");
                    annotation_1.getDetails().put((Object)"type_name", (Object)type_name);
                    ELPackage types_package = operation.getEType().getEPackage();
                    System.out.println("types_package" + types_package);
                    if (processedELPackages.indexOf((Object)types_package) == -1 && types_package != null && !Objects.equal((Object)types_package.getName(), (Object)"types") && !Objects.equal((Object)types_package, (Object)elpackage)) {
                        processedELPackages.add((Object)types_package);
                        dependantEcorePackages.add((Object)this.processPackage(types_package, fsa));
                    }
                    e_operation.getEAnnotations().add((Object)annotation_1);
                    EList _eParameters = operation.getEParameters();
                    for (ELParameter param : _eParameters) {
                        EParameter e_param = EcoreFactory.eINSTANCE.createEParameter();
                        e_param.setName(param.getName());
                        e_operation.getEParameters().add((Object)e_param);
                        String param_type_name = param.getEType().getName();
                        EAnnotation param_annotation = EcoreFactory.eINSTANCE.createEAnnotation();
                        param_annotation.setSource("temp");
                        param_annotation.getDetails().put((Object)"type_name", (Object)param_type_name);
                        ELPackage param_types_package = param.getEType().getEPackage();
                        if (processedELPackages.indexOf((Object)param_types_package) == -1 && param_types_package != null && !Objects.equal((Object)param_types_package.getName(), (Object)"types") && !Objects.equal((Object)param_types_package, (Object)elpackage)) {
                            processedELPackages.add((Object)param_types_package);
                            dependantEcorePackages.add((Object)this.processPackage(param_types_package, fsa));
                        }
                        e_param.getEAnnotations().add((Object)param_annotation);
                    }
                }
                ecore_package.getEClassifiers().add((Object)e_class);
            }
            String _name_1 = ecore_package.getName();
            String _plus_2 = "ecore_package = " + _name_1;
            System.out.println(_plus_2);
            EList _eClassifiers_1 = ecore_package.getEClassifiers();
            for (EClassifier classifier_1 : _eClassifiers_1) {
                boolean _greaterThan;
                if (!(classifier_1 instanceof EClass)) continue;
                int _size = ((EClass)classifier_1).getEAnnotations().size();
                boolean bl = _greaterThan = _size > 0;
                if (_greaterThan) {
                    EAnnotation firstAnnotation = (EAnnotation)((EClass)classifier_1).getEAnnotations().get(0);
                    EMap details = firstAnnotation.getDetails();
                    String superTypeName = (String)details.get((Object)"superTypeName");
                    ((EClass)classifier_1).getESuperTypes().add((Object)this.findClass(ecore_package, (BasicEList<EPackage>)dependantEcorePackages, superTypeName));
                    ((EClass)classifier_1).getEAnnotations().remove(0);
                }
                _eStructuralFeatures = ((EClass)classifier_1).getEStructuralFeatures();
                for (EStructuralFeature structural_feature : _eStructuralFeatures) {
                    boolean _greaterThan_2;
                    if (structural_feature instanceof EAttribute) {
                        boolean _greaterThan_1;
                        int _size_1 = ((EAttribute)structural_feature).getEAnnotations().size();
                        boolean bl5 = _greaterThan_1 = _size_1 > 0;
                        if (_greaterThan_1) {
                            EAnnotation firstAttributeAnnotation = (EAnnotation)((EAttribute)structural_feature).getEAnnotations().get(0);
                            EMap attributeDetails = firstAttributeAnnotation.getDetails();
                            String attribute_type_name = (String)attributeDetails.get((Object)"attribute_type_name");
                            EEnum e_type = this.findEnum(ecore_package, (BasicEList<EPackage>)dependantEcorePackages, attribute_type_name);
                            ((EAttribute)structural_feature).setEType((EClassifier)e_type);
                            ((EAttribute)structural_feature).getEAnnotations().remove(0);
                        }
                    }
                    if (!(structural_feature instanceof EReference)) continue;
                    int _size_2 = ((EReference)structural_feature).getEAnnotations().size();
                    boolean bl6 = _greaterThan_2 = _size_2 > 0;
                    if (!_greaterThan_2) continue;
                    EAnnotation firstAttributeAnnotation_1 = (EAnnotation)((EReference)structural_feature).getEAnnotations().get(0);
                    EMap attributeDetails_1 = firstAttributeAnnotation_1.getDetails();
                    String reference_type_name = (String)attributeDetails_1.get((Object)"type");
                    ((EReference)structural_feature).setEType((EClassifier)this.findClass(ecore_package, (BasicEList<EPackage>)dependantEcorePackages, reference_type_name));
                    ((EReference)structural_feature).getEAnnotations().remove(0);
                }
                _eOperations = ((EClass)classifier_1).getEOperations();
                for (EOperation operation : _eOperations) {
                    EAnnotation firstOperationAnnotation = (EAnnotation)operation.getEAnnotations().get(0);
                    EMap attributeDetails = firstOperationAnnotation.getDetails();
                    String operationTypeName = (String)attributeDetails.get((Object)"type_name");
                    EClass operationTypesClass = this.findClass(ecore_package, (BasicEList<EPackage>)dependantEcorePackages, operationTypeName);
                    if (operationTypesClass != null) {
                        operation.setEType((EClassifier)operationTypesClass);
                    } else {
                        boolean _equals = Objects.equal((Object)operationTypeName, (Object)"double");
                        if (_equals) {
                            operation.setEType((EClassifier)EcorePackage.Literals.EDOUBLE);
                        } else {
                            boolean _equals_1 = Objects.equal((Object)operationTypeName, (Object)"String");
                            if (_equals_1) {
                                operation.setEType((EClassifier)EcorePackage.Literals.ESTRING);
                            } else {
                                boolean _equals_2 = Objects.equal((Object)operationTypeName, (Object)"String");
                                if (_equals_2) {
                                    operation.setEType((EClassifier)EcorePackage.Literals.ESTRING);
                                } else {
                                    boolean _equals_3 = Objects.equal((Object)operationTypeName, (Object)"int");
                                    if (_equals_3) {
                                        operation.setEType((EClassifier)EcorePackage.Literals.EINT);
                                    } else {
                                        boolean _equals_4 = Objects.equal((Object)operationTypeName, (Object)"Date");
                                        if (_equals_4) {
                                            operation.setEType((EClassifier)EcorePackage.Literals.EDATE);
                                        } else {
                                            boolean _equals_5 = Objects.equal((Object)operationTypeName, (Object)"boolean");
                                            if (_equals_5) {
                                                operation.setEType((EClassifier)EcorePackage.Literals.EBOOLEAN);
                                            } else {
                                                EEnum eEnum = this.findEnum(ecore_package, (BasicEList<EPackage>)dependantEcorePackages, operationTypeName);
                                                operation.setEType((EClassifier)eEnum);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    operation.getEAnnotations().remove(0);
                    EList _eParameters = operation.getEParameters();
                    for (EParameter param : _eParameters) {
                        EAnnotation firstParamAnnotation = (EAnnotation)param.getEAnnotations().get(0);
                        EMap paramAttributeDetails = firstParamAnnotation.getDetails();
                        String paramTypeName = (String)paramAttributeDetails.get((Object)"type_name");
                        EClass paramTypesClass = this.findClass(ecore_package, (BasicEList<EPackage>)dependantEcorePackages, paramTypeName);
                        if (paramTypesClass != null) {
                            param.setEType((EClassifier)paramTypesClass);
                            continue;
                        }
                        boolean _equals_6 = Objects.equal((Object)paramTypeName, (Object)"double");
                        if (_equals_6) {
                            param.setEType((EClassifier)EcorePackage.Literals.EDOUBLE);
                            continue;
                        }
                        boolean _equals_7 = Objects.equal((Object)paramTypeName, (Object)"String");
                        if (_equals_7) {
                            param.setEType((EClassifier)EcorePackage.Literals.ESTRING);
                            continue;
                        }
                        boolean _equals_8 = Objects.equal((Object)paramTypeName, (Object)"String");
                        if (_equals_8) {
                            param.setEType((EClassifier)EcorePackage.Literals.ESTRING);
                            continue;
                        }
                        boolean _equals_9 = Objects.equal((Object)paramTypeName, (Object)"int");
                        if (_equals_9) {
                            param.setEType((EClassifier)EcorePackage.Literals.EINT);
                            continue;
                        }
                        boolean _equals_10 = Objects.equal((Object)paramTypeName, (Object)"Date");
                        if (_equals_10) {
                            param.setEType((EClassifier)EcorePackage.Literals.EDATE);
                            continue;
                        }
                        boolean _equals_11 = Objects.equal((Object)paramTypeName, (Object)"boolean");
                        if (_equals_11) {
                            param.setEType((EClassifier)EcorePackage.Literals.EBOOLEAN);
                            continue;
                        }
                        EEnum eEnum_1 = this.findEnum(ecore_package, (BasicEList<EPackage>)dependantEcorePackages, paramTypeName);
                        param.setEType((EClassifier)eEnum_1);
                        param.getEAnnotations().remove(0);
                    }
                }
            }
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            if (dependantEcorePackages != null) {
                for (EPackage dependantEcorePackage : dependantEcorePackages) {
                    String _name_2 = dependantEcorePackage.getName();
                    String _plus_3 = String.valueOf(_name_2) + ".ecore";
                    Resource dependentEcoreResource = resourceSet.createResource(URI.createFileURI((String)_plus_3));
                    dependentEcoreResource.getContents().add((Object)dependantEcorePackage);
                    dependentEcoreResource.save(null);
                }
            }
            String _name_2 = ecore_package.getName();
            String _plus_3 = String.valueOf(_name_2) + ".ecore";
            Resource ecoreResource = resourceSet.createResource(URI.createFileURI((String)_plus_3));
            ecoreResource.getContents().add((Object)ecore_package);
            ecoreResource.save(null);
            String _name_3 = ecore_package.getName();
            String _plus_4 = String.valueOf(_name_3) + ".ecore";
            Path filePath = Path.of(_plus_4, new String[0]);
            String content = Files.readString(filePath);
            String _name_4 = ecore_package.getName();
            String _plus_5 = String.valueOf(_name_4) + ".ecore";
            fsa.generateFile(_plus_5, (CharSequence)content);
            return ecore_package;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String findXCoreSubstring(String string) {
        int startIndex = string.indexOf("<xcore>");
        int endIndex = string.indexOf("</xcore>");
        String returnString = string;
        if (endIndex > 0 && startIndex > -1) {
            returnString = string.substring(startIndex + 7, endIndex);
        }
        return returnString;
    }

    public EEnum findEnum(EPackage thePackage, BasicEList<EPackage> dependantPackages, String enumName) {
        EEnum returnEnum = null;
        EList _eClassifiers = thePackage.getEClassifiers();
        for (EClassifier classifier : _eClassifiers) {
            String _name;
            boolean _equals;
            if (!(classifier instanceof EEnum) || !(_equals = Objects.equal((Object)(_name = ((EEnum)classifier).getName()), (Object)enumName))) continue;
            returnEnum = (EEnum)classifier;
        }
        if (returnEnum == null) {
            for (EPackage dependantPackage : dependantPackages) {
                if (dependantPackage == null) continue;
                EList _eClassifiers_1 = dependantPackage.getEClassifiers();
                for (EClassifier classifier_1 : _eClassifiers_1) {
                    String _name_1;
                    boolean _equals_1;
                    if (!(classifier_1 instanceof EEnum) || !(_equals_1 = Objects.equal((Object)(_name_1 = ((EEnum)classifier_1).getName()), (Object)enumName))) continue;
                    returnEnum = (EEnum)classifier_1;
                }
            }
        }
        System.out.println("returnEnum = " + returnEnum);
        if (returnEnum != null) {
            String _name_2 = returnEnum.getName();
            String _plus = "returnEnum name = " + _name_2;
            System.out.println(_plus);
        }
        return returnEnum;
    }

    public EClass findClass(EPackage thePackage, BasicEList<EPackage> dependantPackages, String className) {
        EClass returnClass = null;
        EList _eClassifiers = thePackage.getEClassifiers();
        for (EClassifier classifier : _eClassifiers) {
            String _name;
            boolean _equals;
            if (!(classifier instanceof EClass) || !(_equals = Objects.equal((Object)(_name = ((EClass)classifier).getName()), (Object)className))) continue;
            returnClass = (EClass)classifier;
        }
        if (returnClass == null) {
            for (EPackage dependantPackage : dependantPackages) {
                if (dependantPackage == null) continue;
                EList _eClassifiers_1 = dependantPackage.getEClassifiers();
                for (EClassifier classifier_1 : _eClassifiers_1) {
                    String _name_1;
                    boolean _equals_1;
                    if (!(classifier_1 instanceof EClass) || !(_equals_1 = Objects.equal((Object)(_name_1 = ((EClass)classifier_1).getName()), (Object)className))) continue;
                    returnClass = (EClass)classifier_1;
                }
            }
        }
        return returnClass;
    }
}

