/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.ui.text.Chain;
import org.eclipse.jdt.internal.ui.text.ChainElementAnalyzer;
import org.eclipse.jdt.internal.ui.text.ChainType;

public class ChainElement {
    private final IJavaElement element;
    private ChainType returnType;
    private int dimension;
    private ElementType elementType;
    private final boolean requireThis;

    public ChainElement(IJavaElement element, boolean requireThis) {
        if (element == null) {
            throw new IllegalArgumentException("???");
        }
        this.element = element;
        this.requireThis = requireThis;
        this.initializeReturnType();
    }

    private void initializeReturnType() {
        String signature = null;
        IJavaProject proj = this.element.getJavaProject();
        switch (this.element.getElementType()) {
            case 8: {
                this.elementType = ElementType.FIELD;
                try {
                    signature = ((IField)this.element).getTypeSignature();
                }
                catch (JavaModelException javaModelException) {}
                IType declType = ((IField)this.element).getDeclaringType();
                this.setReturnType(proj, signature, declType);
                break;
            }
            case 14: {
                this.elementType = ElementType.LOCAL_VARIABLE;
                signature = ((ILocalVariable)this.element).getTypeSignature();
                IType declType = ((ILocalVariable)this.element).getDeclaringMember().getDeclaringType();
                this.setReturnType(proj, signature, declType);
                break;
            }
            case 9: {
                this.elementType = ElementType.METHOD;
                try {
                    signature = ((IMethod)this.element).getReturnType();
                }
                catch (JavaModelException javaModelException) {}
                IType declType = ((IMethod)this.element).getDeclaringType();
                this.setReturnType(proj, signature, declType);
                break;
            }
            case 7: {
                this.elementType = ElementType.TYPE;
                this.returnType = new ChainType((IType)this.element);
            }
        }
        this.dimension = signature == null ? 0 : Signature.getArrayCount(signature);
    }

    private void setReturnType(IJavaProject proj, String signature, IType declType) {
        IType res;
        this.returnType = ChainElementAnalyzer.isPrimitive(signature) ? new ChainType(signature) : ((res = ChainElementAnalyzer.getTypeFromSignature(proj, signature, declType)) != null ? new ChainType(res) : new ChainType(signature));
    }

    public IJavaElement getElement() {
        return this.element;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public ChainType getReturnType() {
        return this.returnType;
    }

    public int getReturnTypeDimension() {
        return this.dimension;
    }

    public boolean requiresThisForQualification() {
        return this.requireThis;
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChainElement) {
            ChainElement other = (ChainElement)obj;
            return this.element.equals(other.element);
        }
        return false;
    }

    public String toString() {
        if (this.elementType == ElementType.METHOD) {
            IMethod m = (IMethod)this.element;
            StringBuilder ret = new StringBuilder(m.getElementName());
            try {
                return ret.append(m.getSignature()).toString();
            }
            catch (JavaModelException javaModelException) {
                return ret.toString();
            }
        }
        return this.element.toString();
    }

    public static String createChainCode(Chain chain, boolean createAsTitle, int expectedDimension) {
        HashMap<String, Integer> varNames = new HashMap<String, Integer>();
        StringBuilder sb = new StringBuilder(64);
        for (ChainElement edge : chain.getElements()) {
            switch (edge.getElementType()) {
                case FIELD: 
                case LOCAL_VARIABLE: 
                case TYPE: {
                    ChainElement.appendVariableString(edge, sb);
                    break;
                }
                case METHOD: {
                    IMethod method = (IMethod)edge.getElement();
                    if (createAsTitle) {
                        StringBuffer tmp = new StringBuffer(sb.toString());
                        JavaElementLabelsCore.getMethodLabel(method, 0x200009L, tmp);
                        sb = new StringBuilder(tmp.toString());
                        break;
                    }
                    sb.append(method.getElementName());
                    ChainElement.appendParameters(sb, method, varNames);
                }
            }
            boolean appendVariables = !createAsTitle;
            ChainElement.appendArrayDimensions(sb, edge.getReturnTypeDimension(), expectedDimension, appendVariables, varNames);
            sb.append(".");
        }
        ChainElement.deleteLastChar(sb);
        return sb.toString();
    }

    private static void appendVariableString(ChainElement edge, StringBuilder sb) {
        if (edge.requiresThisForQualification() && sb.length() == 0) {
            sb.append("this.");
        }
        sb.append(edge.getElement().getElementName());
    }

    private static void appendParameters(StringBuilder sb, IMethod method, Map<String, Integer> varNames) {
        sb.append("(");
        String[] stringArray = method.getParameterTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String typeSig = stringArray[n2];
            String parameterName = Signature.getSignatureSimpleName((String)Signature.getElementType((String)typeSig));
            int index = (parameterName = String.valueOf(parameterName.substring(0, 1).toLowerCase()) + parameterName.substring(1)).indexOf(60);
            if (index != -1) {
                parameterName = parameterName.substring(0, index);
            }
            ChainElement.appendTemplateVariable(sb, parameterName, varNames);
            sb.append(", ");
            ++n2;
        }
        if (method.getParameterTypes().length > 0) {
            ChainElement.deleteLastChar(sb);
            ChainElement.deleteLastChar(sb);
        }
        sb.append(")");
    }

    private static void appendTemplateVariable(StringBuilder sb, String varname, Map<String, Integer> varNames) {
        int val = varNames.containsKey(varname) ? varNames.get(varname) : 0;
        varNames.put(varname, val + 1);
        sb.append("${").append(varname);
        int count = varNames.get(varname);
        if (count > 1) {
            sb.append(count);
        }
        sb.append("}");
    }

    private static void appendArrayDimensions(StringBuilder sb, int dimension, int expectedDimension, boolean appendVariables, Map<String, Integer> varNames) {
        int i = dimension;
        while (i-- > expectedDimension) {
            sb.append("[");
            if (appendVariables) {
                ChainElement.appendTemplateVariable(sb, "i", varNames);
            }
            sb.append("]");
        }
    }

    private static StringBuilder deleteLastChar(StringBuilder sb) {
        return sb.deleteCharAt(sb.length() - 1);
    }

    public static enum ElementType {
        METHOD,
        FIELD,
        LOCAL_VARIABLE,
        TYPE;

    }
}

